/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom;

import gov.nasa.worldwind.Cacheable;
import gov.nasa.worldwind.Globe;
import gov.nasa.worldwind.TrackPoint;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Cylinder;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Point;
import gov.nasa.worldwind.geom.Sphere;
import java.util.Iterator;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sector
implements Cacheable,
Comparable<Sector> {
    public static final Sector FULL_SPHERE = new Sector(Angle.NEG90, Angle.POS90, Angle.NEG180, Angle.POS180);
    public static final Sector EMPTY_SECTOR = new Sector(Angle.ZERO, Angle.ZERO, Angle.ZERO, Angle.ZERO);
    private final Angle minLatitude;
    private final Angle maxLatitude;
    private final Angle minLongitude;
    private final Angle maxLongitude;
    private final Angle deltaLat;
    private final Angle deltaLon;

    public static Sector fromDegrees(double d, double d2, double d3, double d4) {
        return new Sector(Angle.fromDegrees(d), Angle.fromDegrees(d2), Angle.fromDegrees(d3), Angle.fromDegrees(d4));
    }

    public static Sector fromRadians(double d, double d2, double d3, double d4) {
        return new Sector(Angle.fromRadians(d), Angle.fromRadians(d2), Angle.fromRadians(d3), Angle.fromRadians(d4));
    }

    public static Sector boundingSector(Iterator<TrackPoint> iterator) {
        if (iterator == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.TracksPointsIteratorNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (!iterator.hasNext()) {
            return EMPTY_SECTOR;
        }
        TrackPoint trackPoint = iterator.next();
        double d = trackPoint.getLatitude();
        double d2 = trackPoint.getLongitude();
        double d3 = d;
        double d4 = d2;
        while (iterator.hasNext()) {
            TrackPoint trackPoint2 = iterator.next();
            double d5 = trackPoint2.getLatitude();
            if (d5 < d) {
                d = d5;
            } else if (d5 > d3) {
                d3 = d5;
            }
            double d6 = trackPoint2.getLongitude();
            if (d6 < d2) {
                d2 = d6;
                continue;
            }
            if (!(d6 > d4)) continue;
            d4 = d6;
        }
        return Sector.fromDegrees(d, d3, d2, d4);
    }

    public static Sector boundingSector(Iterable<LatLon> iterable) {
        if (iterable == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.PositionsListIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        double d = Angle.POS90.getDegrees();
        double d2 = Angle.POS180.getDegrees();
        double d3 = Angle.NEG180.getDegrees();
        double d4 = Angle.NEG180.getDegrees();
        for (LatLon latLon : iterable) {
            double d5;
            double d6 = latLon.getLatitude().getDegrees();
            if (d6 < d) {
                d = d6;
            }
            if (d6 > d3) {
                d3 = d6;
            }
            if ((d5 = latLon.getLongitude().getDegrees()) < d2) {
                d2 = d5;
            }
            if (!(d5 > d4)) continue;
            d4 = d5;
        }
        if (d == d3 && d2 == d4) {
            return EMPTY_SECTOR;
        }
        return Sector.fromDegrees(d, d3, d2, d4);
    }

    public Sector(Angle angle, Angle angle2, Angle angle3, Angle angle4) {
        if (angle == null || angle2 == null || angle3 == null || angle4 == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.InputAnglesNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.minLatitude = angle;
        this.maxLatitude = angle2;
        this.minLongitude = angle3;
        this.maxLongitude = angle4;
        this.deltaLat = Angle.fromDegrees(this.maxLatitude.degrees - this.minLatitude.degrees);
        this.deltaLon = Angle.fromDegrees(this.maxLongitude.degrees - this.minLongitude.degrees);
    }

    public Sector(Sector sector) {
        if (sector == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.SectorIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.minLatitude = new Angle(sector.getMinLatitude());
        this.maxLatitude = new Angle(sector.getMaxLatitude());
        this.minLongitude = new Angle(sector.getMinLongitude());
        this.maxLongitude = new Angle(sector.getMaxLongitude());
        this.deltaLat = Angle.fromDegrees(this.maxLatitude.degrees - this.minLatitude.degrees);
        this.deltaLon = Angle.fromDegrees(this.maxLongitude.degrees - this.minLongitude.degrees);
    }

    public final Angle getMinLatitude() {
        return this.minLatitude;
    }

    public final Angle getMinLongitude() {
        return this.minLongitude;
    }

    public final Angle getMaxLatitude() {
        return this.maxLatitude;
    }

    public final Angle getMaxLongitude() {
        return this.maxLongitude;
    }

    public final Angle getDeltaLat() {
        return this.deltaLat;
    }

    public final double getDeltaLatDegrees() {
        return this.deltaLat.degrees;
    }

    public final double getDeltaLatRadians() {
        return this.deltaLat.radians;
    }

    public final Angle getDeltaLon() {
        return this.deltaLon;
    }

    public final double getDeltaLonDegrees() {
        return this.deltaLon.degrees;
    }

    public final double getDeltaLonRadians() {
        return this.deltaLon.radians;
    }

    public final LatLon getCentroid() {
        Angle angle = Angle.fromDegrees(0.5 * (this.getMaxLatitude().degrees + this.getMinLatitude().degrees));
        Angle angle2 = Angle.fromDegrees(0.5 * (this.getMaxLongitude().degrees + this.getMinLongitude().degrees));
        return new LatLon(angle, angle2);
    }

    public Point computeCenterPoint(Globe globe) {
        if (globe == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.GlobeIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        double d = 0.5 * (this.minLatitude.degrees + this.maxLatitude.degrees);
        double d2 = 0.5 * (this.minLongitude.degrees + this.maxLongitude.degrees);
        Angle angle = Angle.fromDegrees(d);
        Angle angle2 = Angle.fromDegrees(d2);
        return globe.computePointFromPosition(angle, angle2, globe.getElevation(angle, angle2));
    }

    public Point[] computeCornerPoints(Globe globe) {
        if (globe == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.GlobeIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        Point[] pointArray = new Point[4];
        Angle angle = this.minLatitude;
        Angle angle2 = this.maxLatitude;
        Angle angle3 = this.minLongitude;
        Angle angle4 = this.maxLongitude;
        pointArray[0] = globe.computePointFromPosition(angle, angle3, globe.getElevation(angle, angle3));
        pointArray[1] = globe.computePointFromPosition(angle, angle4, globe.getElevation(angle, angle4));
        pointArray[2] = globe.computePointFromPosition(angle2, angle4, globe.getElevation(angle2, angle4));
        pointArray[3] = globe.computePointFromPosition(angle2, angle3, globe.getElevation(angle2, angle3));
        return pointArray;
    }

    public static Extent computeBoundingSphere(Globe globe, double d, Sector sector) {
        if (globe == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.GlobeIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (sector == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.SectorIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        LatLon latLon = sector.getCentroid();
        double d2 = globe.getMaxElevation() * d;
        double d3 = 0.0;
        Point[] pointArray = new Point[]{globe.computePointFromPosition(latLon.getLatitude(), latLon.getLongitude(), d2), globe.computePointFromPosition(sector.getMaxLatitude(), sector.getMinLongitude(), d2), globe.computePointFromPosition(sector.getMinLatitude(), sector.getMaxLongitude(), d2), globe.computePointFromPosition(sector.getMinLatitude(), sector.getMinLongitude(), d2), globe.computePointFromPosition(sector.getMaxLatitude(), sector.getMaxLongitude(), d2), globe.computePointFromPosition(sector.getMaxLatitude(), sector.getMinLongitude(), d3), globe.computePointFromPosition(sector.getMinLatitude(), sector.getMaxLongitude(), d3), globe.computePointFromPosition(sector.getMinLatitude(), sector.getMinLongitude(), d3), globe.computePointFromPosition(sector.getMaxLatitude(), sector.getMaxLongitude(), d3)};
        return Sphere.createBoundingSphere(pointArray);
    }

    public static Cylinder computeBoundingCylinder(Globe globe, double d, Sector sector) {
        if (globe == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.GlobeIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (sector == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.SectorIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        LatLon latLon = sector.getCentroid();
        double d2 = globe.getMaxElevation() * d;
        double d3 = 0.0;
        Point point = globe.computePointFromPosition(latLon.getLatitude(), latLon.getLongitude(), d2);
        Point point2 = globe.computePointFromPosition(sector.getMinLatitude(), sector.getMinLongitude(), d3);
        Point point3 = point.normalize();
        double d4 = point3.dot(point2);
        Point point4 = point3.scale(d4, d4, d4);
        Point point5 = globe.computePointFromPosition(sector.getMaxLatitude(), sector.getMinLongitude(), d2);
        Point point6 = globe.computePointFromPosition(sector.getMinLatitude(), sector.getMaxLongitude(), d2);
        Point point7 = globe.computePointFromPosition(sector.getMinLatitude(), sector.getMinLongitude(), d2);
        Point point8 = globe.computePointFromPosition(sector.getMaxLatitude(), sector.getMaxLongitude(), d2);
        double d5 = point7.distanceTo(point6);
        double d6 = point6.distanceTo(point8);
        double d7 = point8.distanceTo(point5);
        double d8 = point5.distanceTo(point7);
        double d9 = 0.5 * (d5 + d6 + d7 + d8);
        double d10 = Math.sqrt((d9 - d5) * (d9 - d6) * (d9 - d7) * (d9 - d8));
        double d11 = Math.sqrt((d5 * d6 + d7 * d8) * (d5 * d8 + d6 * d7) * (d5 * d7 + d6 * d8)) / (4.0 * d10);
        return new Cylinder(point4, point, d11);
    }

    public final boolean contains(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.LatLonIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        return angle.degrees >= this.minLatitude.degrees && angle.degrees <= this.maxLatitude.degrees && angle2.degrees >= this.minLongitude.degrees && angle2.degrees <= this.maxLongitude.degrees;
    }

    public final boolean contains(LatLon latLon) {
        if (latLon == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.LatLonIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        return this.contains(latLon.getLatitude(), latLon.getLongitude());
    }

    public final boolean containsRadians(double d, double d2) {
        return d >= this.minLatitude.radians && d <= this.maxLatitude.radians && d2 >= this.minLongitude.radians && d2 <= this.maxLongitude.radians;
    }

    public final boolean containsDegrees(double d, double d2) {
        return d >= this.minLatitude.degrees && d <= this.maxLatitude.degrees && d2 >= this.minLongitude.degrees && d2 <= this.maxLongitude.degrees;
    }

    public boolean intersects(Sector sector) {
        if (sector == null) {
            return false;
        }
        if (sector.maxLongitude.degrees < this.minLongitude.degrees) {
            return false;
        }
        if (sector.minLongitude.degrees > this.maxLongitude.degrees) {
            return false;
        }
        if (sector.maxLatitude.degrees < this.minLatitude.degrees) {
            return false;
        }
        return !(sector.minLatitude.degrees > this.maxLatitude.degrees);
    }

    public final Sector union(Sector sector) {
        if (sector == null) {
            return this;
        }
        Angle angle = this.minLatitude;
        Angle angle2 = this.maxLatitude;
        Angle angle3 = this.minLongitude;
        Angle angle4 = this.maxLongitude;
        if (sector.minLatitude.degrees < this.minLatitude.degrees) {
            angle = sector.minLatitude;
        }
        if (sector.maxLatitude.degrees > this.maxLatitude.degrees) {
            angle2 = sector.maxLatitude;
        }
        if (sector.minLongitude.degrees < this.minLongitude.degrees) {
            angle3 = sector.minLongitude;
        }
        if (sector.maxLongitude.degrees > this.maxLongitude.degrees) {
            angle4 = sector.maxLongitude;
        }
        return new Sector(angle, angle2, angle3, angle4);
    }

    public final Sector union(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            return this;
        }
        Angle angle3 = this.minLatitude;
        Angle angle4 = this.maxLatitude;
        Angle angle5 = this.minLongitude;
        Angle angle6 = this.maxLongitude;
        if (angle.degrees < this.minLatitude.degrees) {
            angle3 = angle;
        }
        if (angle.degrees > this.maxLatitude.degrees) {
            angle4 = angle;
        }
        if (angle2.degrees < this.minLongitude.degrees) {
            angle5 = angle2;
        }
        if (angle2.degrees > this.maxLongitude.degrees) {
            angle6 = angle2;
        }
        return new Sector(angle3, angle4, angle5, angle6);
    }

    public final Sector intersection(Sector sector) {
        Angle angle;
        Angle angle2;
        if (sector == null) {
            return this;
        }
        Angle angle3 = this.minLatitude.degrees > sector.minLatitude.degrees ? this.minLatitude : sector.minLatitude;
        Angle angle4 = angle2 = this.maxLatitude.degrees < sector.maxLatitude.degrees ? this.maxLatitude : sector.maxLatitude;
        if (angle3.degrees > angle2.degrees) {
            return null;
        }
        Angle angle5 = this.minLongitude.degrees > sector.minLongitude.degrees ? this.minLongitude : sector.minLongitude;
        Angle angle6 = angle = this.maxLongitude.degrees < sector.maxLongitude.degrees ? this.maxLongitude : sector.maxLongitude;
        if (angle5.degrees > angle.degrees) {
            return null;
        }
        return new Sector(angle3, angle2, angle5, angle);
    }

    public final Sector intersection(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            return this;
        }
        if (!this.contains(angle, angle2)) {
            return null;
        }
        return new Sector(angle, angle, angle2, angle2);
    }

    public final Sector[] subdivide() {
        Angle angle = Angle.average(this.minLatitude, this.maxLatitude);
        Angle angle2 = Angle.average(this.minLongitude, this.maxLongitude);
        Sector[] sectorArray = new Sector[]{new Sector(this.minLatitude, angle, this.minLongitude, angle2), new Sector(this.minLatitude, angle, angle2, this.maxLongitude), new Sector(angle, this.maxLatitude, this.minLongitude, angle2), new Sector(angle, this.maxLatitude, angle2, this.maxLongitude)};
        return sectorArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        stringBuffer.append(this.minLatitude.toString());
        stringBuffer.append(", ");
        stringBuffer.append(this.minLongitude.toString());
        stringBuffer.append(")");
        stringBuffer.append(", ");
        stringBuffer.append("(");
        stringBuffer.append(this.maxLatitude.toString());
        stringBuffer.append(", ");
        stringBuffer.append(this.maxLongitude.toString());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    @Override
    public long getSizeInBytes() {
        return 4L * this.minLatitude.getSizeInBytes();
    }

    @Override
    public int compareTo(Sector sector) {
        if (sector == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.SectorIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (this.getMinLatitude().compareTo(sector.getMinLatitude()) < 0) {
            return -1;
        }
        if (this.getMinLatitude().compareTo(sector.getMinLatitude()) > 0) {
            return 1;
        }
        if (this.getMinLongitude().compareTo(sector.getMinLongitude()) < 0) {
            return -1;
        }
        if (this.getMinLongitude().compareTo(sector.getMinLongitude()) > 0) {
            return 1;
        }
        if (this.getMaxLatitude().compareTo(sector.getMaxLatitude()) < 0) {
            return -1;
        }
        if (this.getMaxLatitude().compareTo(sector.getMaxLatitude()) > 0) {
            return 1;
        }
        if (this.getMaxLongitude().compareTo(sector.getMaxLongitude()) < 0) {
            return -1;
        }
        if (this.getMaxLongitude().compareTo(sector.getMaxLongitude()) > 0) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Sector sector = (Sector)object;
        if (!this.maxLatitude.equals(sector.maxLatitude)) {
            return false;
        }
        if (!this.maxLongitude.equals(sector.maxLongitude)) {
            return false;
        }
        if (!this.minLatitude.equals(sector.minLatitude)) {
            return false;
        }
        return this.minLongitude.equals(sector.minLongitude);
    }

    public int hashCode() {
        int n = this.minLatitude.hashCode();
        n = 29 * n + this.maxLatitude.hashCode();
        n = 29 * n + this.minLongitude.hashCode();
        n = 29 * n + this.maxLongitude.hashCode();
        return n;
    }
}

