/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom;

import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.SurfaceShape;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SurfacePolygon
extends SurfaceShape {
    public SurfacePolygon(Iterable<LatLon> iterable, Color color, Color color2) {
        super(iterable, color, color2);
    }

    public SurfacePolygon(Iterable<LatLon> iterable) {
        super(iterable, null, null);
    }

    @Override
    protected final BufferedImage drawShape(BufferedImage bufferedImage) {
        Object object;
        double d = this.getSector().getMinLatitude().getDegrees();
        double d2 = this.getSector().getMinLongitude().getDegrees();
        double d3 = this.getSector().getDeltaLatDegrees();
        double d4 = this.getSector().getDeltaLonDegrees();
        double d5 = d3 > 0.0 ? (double)bufferedImage.getHeight() / d3 : 0.0;
        double d6 = d4 > 0.0 ? (double)bufferedImage.getWidth() / d4 : 0.0;
        GeneralPath generalPath = new GeneralPath();
        Iterator<LatLon> iterator = this.getPositions().iterator();
        if (!iterator.hasNext()) {
            return bufferedImage;
        }
        Object object2 = iterator.next();
        generalPath.moveTo((float)Math.min(d6 * (((LatLon)object2).getLongitude().getDegrees() - d2), (double)(bufferedImage.getWidth() - 1)), (float)Math.min(d5 * (((LatLon)object2).getLatitude().getDegrees() - d), (double)(bufferedImage.getHeight() - 1)));
        double d7 = 1.0 / (double)this.getNumEdgeIntervals();
        while (iterator.hasNext()) {
            object = iterator.next();
            for (int i = 0; i < this.getNumEdgeIntervals(); ++i) {
                LatLon latLon = LatLon.interpolate((double)i * d7, (LatLon)object2, (LatLon)object);
                generalPath.lineTo((float)Math.min(d6 * (latLon.getLongitude().getDegrees() - d2), (double)(bufferedImage.getWidth() - 1)), (float)Math.min(d5 * (latLon.getLatitude().getDegrees() - d), (double)(bufferedImage.getHeight() - 1)));
            }
            generalPath.lineTo((float)Math.min(d6 * (((LatLon)object).getLongitude().getDegrees() - d2), (double)(bufferedImage.getWidth() - 1)), (float)Math.min(d5 * (((LatLon)object).getLatitude().getDegrees() - d), (double)(bufferedImage.getHeight() - 1)));
            object2 = object;
        }
        object = bufferedImage.createGraphics();
        if (this.isAntiAlias()) {
            ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (this.isDrawInterior()) {
            ((Graphics2D)object).setPaint(this.getPaint());
            ((Graphics2D)object).fill(generalPath);
        }
        if (this.isDrawBorder()) {
            ((Graphics2D)object).setPaint(this.getBorderColor());
            ((Graphics2D)object).setStroke(this.getStroke());
            ((Graphics2D)object).draw(generalPath);
        }
        return bufferedImage;
    }
}

