/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom;

import com.sun.opengl.util.texture.TextureData;
import gov.nasa.worldwind.Disposable;
import gov.nasa.worldwind.DrawContext;
import gov.nasa.worldwind.Renderable;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.TextureTile;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.media.opengl.GL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SurfaceShape
implements Renderable,
Disposable {
    private static final Color DEFAULT_COLOR = new Color(1.0f, 1.0f, 0.0f, 0.4f);
    private static final Color DEFAULT_BORDER_COLOR = new Color(1.0f, 1.0f, 0.0f, 0.7f);
    private static final int DEFAULT_TEXTURE_SIZE = 512;
    private static final int DEFAULT_NUM_EDGE_INTERVALS = 10;
    private TextureTile tile;
    private int textureSize = 512;
    private Paint paint;
    private Color borderColor;
    private Stroke stroke = new BasicStroke();
    private boolean drawBorder = true;
    private boolean drawInterior = true;
    private boolean antiAlias = true;
    private int numEdgeIntervals = 10;
    private ArrayList<LatLon> positions = new ArrayList();

    protected abstract BufferedImage drawShape(BufferedImage var1);

    public SurfaceShape(Iterable<LatLon> iterable, Color color, Color color2) {
        if (iterable == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.PositionsListIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.createTextureTiles(Sector.boundingSector(iterable));
        this.paint = color != null ? color : DEFAULT_COLOR;
        this.borderColor = color2 != null ? color2 : DEFAULT_BORDER_COLOR;
        for (LatLon latLon : iterable) {
            this.positions.add(latLon);
        }
    }

    private void createTextureTiles(Sector sector) {
        this.tile = new TextureTile(sector);
    }

    @Override
    public void dispose() {
        if (this.tile != null) {
            this.tile.dispose();
        }
    }

    public Sector getSector() {
        return this.tile.getSector();
    }

    public ArrayList<LatLon> getPositions() {
        return this.positions;
    }

    private TextureTile getTextureTile() {
        return this.tile;
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        this.paint = paint;
        this.getTextureTile().setTextureData(null);
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
        this.getTextureTile().setTextureData(null);
    }

    public int getTextureSize() {
        return this.textureSize;
    }

    public void setTextureSize(int n) {
        this.textureSize = n;
        this.getTextureTile().setTextureData(null);
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
        this.getTextureTile().setTextureData(null);
    }

    public boolean isDrawBorder() {
        return this.drawBorder;
    }

    public void setDrawBorder(boolean bl) {
        this.drawBorder = bl;
    }

    public boolean isDrawInterior() {
        return this.drawInterior;
    }

    public void setDrawInterior(boolean bl) {
        this.drawInterior = bl;
    }

    public boolean isAntiAlias() {
        return this.antiAlias;
    }

    public void setAntiAlias(boolean bl) {
        this.antiAlias = bl;
    }

    public int getNumEdgeIntervals() {
        return this.numEdgeIntervals;
    }

    public void setNumEdgeIntervals(int n) {
        this.numEdgeIntervals = n;
    }

    private boolean intersects(Sector sector) {
        return this.tile.getSector().intersects(sector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(DrawContext drawContext) {
        if (!this.intersects(drawContext.getVisibleSector())) {
            return;
        }
        if (this.getTextureTile().getTextureData() == null) {
            this.tile.setTextureData(this.makeTextureData(this.textureSize));
        }
        GL gL = drawContext.getGL();
        gL.glPushAttrib(16392);
        try {
            if (!drawContext.isPickingMode()) {
                gL.glEnable(3042);
                gL.glBlendFunc(770, 771);
            }
            gL.glPolygonMode(1028, 6914);
            gL.glEnable(2884);
            gL.glCullFace(1029);
            drawContext.getSurfaceTileRenderer().renderTile(drawContext, this.tile);
        }
        finally {
            gL.glPopAttrib();
        }
    }

    private TextureData makeTextureData(int n) {
        BufferedImage bufferedImage = new BufferedImage(n, n, 6);
        TextureData textureData = new TextureData(6408, 6408, false, this.drawShape(bufferedImage));
        textureData.setMustFlipVertically(false);
        return textureData;
    }
}

