/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom;

import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Frustum;
import gov.nasa.worldwind.geom.Matrix4;
import gov.nasa.worldwind.geom.Plane;
import java.util.logging.Level;

public class ViewFrustum {
    private final Frustum frustum;
    private final Matrix4 projection;

    public ViewFrustum(Matrix4 matrix4) {
        if (matrix4 == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.MatrixIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        double[] dArray = matrix4.getEntries();
        double d = Math.sqrt((dArray[3] + dArray[2]) * (dArray[3] + dArray[2]) + (dArray[7] + dArray[6]) * (dArray[7] + dArray[6]) + (dArray[11] + dArray[10]) * (dArray[11] + dArray[10]));
        Plane plane = new Plane((dArray[3] + dArray[2]) / d, (dArray[7] + dArray[6]) / d, (dArray[11] + dArray[10]) / d, dArray[15] + dArray[14]);
        double d2 = Math.sqrt((dArray[3] - dArray[2]) * (dArray[3] - dArray[2]) + (dArray[7] - dArray[6]) * (dArray[7] - dArray[6]) + (dArray[11] - dArray[10]) * (dArray[11] - dArray[10]));
        Plane plane2 = new Plane((dArray[3] - dArray[2]) / d2, (dArray[7] - dArray[6]) / d2, (dArray[11] - dArray[10]) / d2, dArray[15] - dArray[14]);
        double d3 = Math.sqrt((dArray[3] + dArray[0]) * (dArray[3] + dArray[0]) + (dArray[7] + dArray[4]) * (dArray[7] + dArray[4]) + (dArray[11] + dArray[8]) * (dArray[11] + dArray[8]));
        Plane plane3 = new Plane((dArray[3] + dArray[0]) / d3, (dArray[7] + dArray[4]) / d3, (dArray[11] + dArray[8]) / d3, dArray[15] + dArray[12]);
        double d4 = Math.sqrt((dArray[3] - dArray[0]) * (dArray[3] - dArray[0]) + (dArray[7] - dArray[4]) * (dArray[7] - dArray[4]) + (dArray[11] - dArray[8]) * (dArray[11] - dArray[8]));
        Plane plane4 = new Plane((dArray[3] - dArray[0]) / d4, (dArray[7] - dArray[4]) / d4, (dArray[11] - dArray[8]) / d4, dArray[15] - dArray[12]);
        double d5 = Math.sqrt((dArray[3] + dArray[1]) * (dArray[3] + dArray[1]) + (dArray[7] + dArray[5]) * (dArray[7] + dArray[5]) + (dArray[11] + dArray[9]) * (dArray[11] + dArray[9]));
        Plane plane5 = new Plane((dArray[3] + dArray[1]) / d5, (dArray[7] + dArray[5]) / d5, (dArray[11] + dArray[9]) / d5, dArray[15] + dArray[13]);
        double d6 = Math.sqrt((dArray[3] - dArray[1]) * (dArray[3] - dArray[1]) + (dArray[7] - dArray[5]) * (dArray[7] - dArray[5]) + (dArray[11] - dArray[9]) * (dArray[11] - dArray[9]));
        Plane plane6 = new Plane((dArray[3] - dArray[1]) / d6, (dArray[7] - dArray[5]) / d6, (dArray[11] - dArray[9]) / d6, dArray[15] - dArray[13]);
        this.frustum = new Frustum(plane, plane2, plane3, plane4, plane5, plane6);
        this.projection = matrix4;
    }

    public ViewFrustum(Angle angle, int n, int n2, double d, double d2) {
        if (angle == null) {
            String string = WorldWind.retrieveErrMsg("geom.ViewFrustum.FieldOfViewIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        double d3 = angle.getDegrees();
        double d4 = d2 - d;
        String string = null;
        if (d3 <= 0.0 || d3 > 180.0) {
            string = WorldWind.retrieveErrMsg("geom.ViewFrustum.FieldOfViewOutOfRange");
        }
        if (d <= 0.0 || d4 <= 0.0) {
            string = WorldWind.retrieveErrMsg("geom.ViewFrusutm.ClippingDistanceOutOfRange");
        }
        if (string != null) {
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        double d5 = 1.0 / angle.tanHalfAngle();
        double d6 = (double)n2 / (double)n;
        double d7 = Math.sqrt(d5 * d5 + 1.0);
        double d8 = Math.sqrt(d5 * d5 + d6 * d6);
        Plane plane = new Plane(0.0, 0.0, -1.0, 0.0 - d);
        Plane plane2 = new Plane(0.0, 0.0, 1.0, d2);
        Plane plane3 = new Plane(d5 / d7, 0.0, 0.0 - 1.0 / d7, 0.0);
        Plane plane4 = new Plane(0.0 - d5 / d7, 0.0, 0.0 - 1.0 / d7, 0.0);
        Plane plane5 = new Plane(0.0, d5 / d8, 0.0 - d6 / d8, 0.0);
        Plane plane6 = new Plane(0.0, 0.0 - d5 / d8, 0.0 - d6 / d8, 0.0);
        double[] dArray = new double[]{d5, 0.0, 0.0, 0.0, 0.0, d5 / d6, 0.0, 0.0, 0.0, 0.0, 0.0 - (d2 + d) / d4, -1.0, 0.0, 0.0, 0.0 - 2.0 * d2 * d / d4, 0.0};
        this.frustum = new Frustum(plane, plane2, plane3, plane4, plane5, plane6);
        this.projection = new Matrix4(dArray);
    }

    public ViewFrustum(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = d2 - d;
        double d8 = d4 - d3;
        double d9 = d6 - d5;
        if (d8 <= 0.0 || d9 <= 0.0 || d7 <= 0.0) {
            String string = WorldWind.retrieveErrMsg("geom.ViewFrusutm.ClippingDistanceOutOfRange");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        Plane plane = new Plane(0.0, 0.0, -1.0, d < 0.0 ? d : 0.0 - d);
        Plane plane2 = new Plane(0.0, 0.0, 1.0, d2 < 0.0 ? 0.0 - d2 : d2);
        Plane plane3 = new Plane(1.0, 0.0, 0.0, d3 < 0.0 ? d3 : 0.0 - d3);
        Plane plane4 = new Plane(-1.0, 0.0, 0.0, d4 < 0.0 ? 0.0 - d4 : d4);
        Plane plane5 = new Plane(0.0, 1.0, 0.0, d5 < 0.0 ? d5 : 0.0 - d5);
        Plane plane6 = new Plane(0.0, -1.0, 0.0, d6 < 0.0 ? 0.0 - d6 : d6);
        double[] dArray = new double[]{2.0 / d8, 0.0, 0.0, 0.0 - (d4 + d3) / d8, 0.0, 0.0 / d9, 0.0, 0.0 - (d6 + d5) / d9, 0.0, 0.0, 0.0 - 2.0 / d7, 0.0 - (d2 + d) / d7, 0.0, 0.0, 0.0, 1.0};
        this.frustum = new Frustum(plane, plane2, plane3, plane4, plane5, plane6);
        this.projection = new Matrix4(dArray);
    }

    public final Frustum getFrustum() {
        return this.frustum;
    }

    public final Matrix4 getProjectionMatrix() {
        return this.projection;
    }
}

