/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.globes;

import gov.nasa.worldwind.AVListImpl;
import gov.nasa.worldwind.BasicElevationModel;
import gov.nasa.worldwind.LevelSet;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;

public class EarthElevationModel
extends BasicElevationModel {
    private static double HEIGHT_OF_MT_EVEREST = 8850.0;
    private static double DEPTH_OF_MARIANAS_TRENCH = -11000.0;

    public EarthElevationModel() {
        super(EarthElevationModel.makeLevels(), DEPTH_OF_MARIANAS_TRENCH, HEIGHT_OF_MT_EVEREST);
        this.setNumExpectedValuesPerTile(22500L);
    }

    private static LevelSet makeLevels() {
        AVListImpl aVListImpl = new AVListImpl();
        aVListImpl.setValue("gov.nasa.worldwind.Level.TileWidthKey", 150);
        aVListImpl.setValue("gov.nasa.worldwind.Level.TileHeightKey", 150);
        aVListImpl.setValue("gov.nasa.worldwind.Level.CacheNameKey", "Earth/srtm30pluszip");
        aVListImpl.setValue("gov.nasa.worldwind.Level.ServiceURLKey", "http://worldwind25.arc.nasa.gov/wwelevation/wwelevation.aspx");
        aVListImpl.setValue("gov.nasa.worldwind.Level.DatasetNameKey", "srtm30pluszip");
        aVListImpl.setValue("gov.nasa.worldwind.Level.FormatSuffixKey", ".bil");
        aVListImpl.setValue("gov.nasa.worldwind.Level.NumLevels", 12);
        aVListImpl.setValue("gov.nasa.worldwind.Level.NumEmptyLevels", 0);
        aVListImpl.setValue("gov.nasa.worldwind.Level.LevelZeroTileDelta", new LatLon(Angle.fromDegrees(20.0), Angle.fromDegrees(20.0)));
        aVListImpl.setValue("gov.nasa.worldwind.avKey.Sector", Sector.FULL_SPHERE);
        return new LevelSet(aVListImpl);
    }
}

