/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.globes;

import com.sun.opengl.util.BufferUtil;
import gov.nasa.worldwind.DrawContext;
import gov.nasa.worldwind.ElevationModel;
import gov.nasa.worldwind.Globe;
import gov.nasa.worldwind.SectorGeometry;
import gov.nasa.worldwind.SectorGeometryList;
import gov.nasa.worldwind.Tessellator;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Cylinder;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.Frustum;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Point;
import gov.nasa.worldwind.geom.PolarPoint;
import gov.nasa.worldwind.geom.Sector;
import java.nio.DoubleBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import javax.media.opengl.GL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EllipsoidIcosahedralTessellator
extends WWObjectImpl
implements Tessellator {
    private static int DEFAULT_DENSITY = 20;
    private static final int DEFAULT_MAX_LEVEL = 14;
    private static Angle P30 = Angle.fromDegrees(30.0);
    private static Angle N30 = Angle.fromDegrees(-30.0);
    private static Angle P36 = Angle.fromDegrees(36.0);
    private static Angle N36 = Angle.fromDegrees(-36.0);
    private static Angle P72 = Angle.fromDegrees(72.0);
    private static Angle N72 = Angle.fromDegrees(-72.0);
    private static Angle P108 = Angle.fromDegrees(108.0);
    private static Angle N108 = Angle.fromDegrees(-108.0);
    private static Angle P144 = Angle.fromDegrees(144.0);
    private static Angle N144 = Angle.fromDegrees(-144.0);
    private static final LatLon[] L0 = new LatLon[]{new LatLon(Angle.POS90, N144), new LatLon(Angle.POS90, N72), new LatLon(Angle.POS90, Angle.ZERO), new LatLon(Angle.POS90, P72), new LatLon(Angle.POS90, P144), new LatLon(P30, Angle.NEG180), new LatLon(P30, N144), new LatLon(P30, N108), new LatLon(P30, N72), new LatLon(P30, N36), new LatLon(P30, Angle.ZERO), new LatLon(P30, P36), new LatLon(P30, P72), new LatLon(P30, P108), new LatLon(P30, P144), new LatLon(P30, Angle.POS180), new LatLon(N30, N144), new LatLon(N30, N108), new LatLon(N30, N72), new LatLon(N30, N36), new LatLon(N30, Angle.ZERO), new LatLon(N30, P36), new LatLon(N30, P72), new LatLon(N30, P108), new LatLon(N30, P144), new LatLon(N30, Angle.POS180), new LatLon(N30, N144), new LatLon(Angle.NEG90, N108), new LatLon(Angle.NEG90, N36), new LatLon(Angle.NEG90, P36), new LatLon(Angle.NEG90, P108), new LatLon(Angle.NEG90, Angle.POS180), new LatLon(P30, Angle.NEG180), new LatLon(N30, Angle.NEG180), new LatLon(Angle.NEG90, Angle.NEG180)};
    private final Globe globe;
    private final GlobeInfo globeInfo;
    private final ArrayList<IcosaTile> topLevels;
    private SectorGeometryList currentTiles = new SectorGeometryList();
    private Frustum currentFrustum;
    private int currentLevel;
    private int maxLevel = 14;
    private Sector sector;
    private int density = DEFAULT_DENSITY;

    public static IcosaTile createTileFromAngles(GlobeInfo globeInfo, int n, LatLon latLon, LatLon latLon2, LatLon latLon3) {
        return new IcosaTile(globeInfo, n, latLon, latLon2, latLon3);
    }

    private static ArrayList<IcosaTile> makeLevelZeroEquilateralTriangles(GlobeInfo globeInfo) {
        ArrayList<IcosaTile> arrayList = new ArrayList<IcosaTile>(22);
        arrayList.add(EllipsoidIcosahedralTessellator.createTileFromAngles(globeInfo, 0, L0[5], L0[7], L0[0]));
        arrayList.add(EllipsoidIcosahedralTessellator.createTileFromAngles(globeInfo, 0, L0[7], L0[9], L0[1]));
        arrayList.add(EllipsoidIcosahedralTessellator.createTileFromAngles(globeInfo, 0, L0[9], L0[11], L0[2]));
        arrayList.add(EllipsoidIcosahedralTessellator.createTileFromAngles(globeInfo, 0, L0[11], L0[13], L0[3]));
        arrayList.add(EllipsoidIcosahedralTessellator.createTileFromAngles(globeInfo, 0, L0[13], L0[15], L0[4]));
        arrayList.add(EllipsoidIcosahedralTessellator.createTileFromAngles(globeInfo, 0, L0[16], L0[7], L0[5]));
        arrayList.add(EllipsoidIcosahedralTessellator.createTileFromAngles(globeInfo, 0, L0[16], L0[18], L0[7]));
        arrayList.add(EllipsoidIcosahedralTessellator.createTileFromAngles(globeInfo, 0, L0[18], L0[9], L0[7]));
        arrayList.add(EllipsoidIcosahedralTessellator.createTileFromAngles(globeInfo, 0, L0[18], L0[20], L0[9]));
        arrayList.add(EllipsoidIcosahedralTessellator.createTileFromAngles(globeInfo, 0, L0[20], L0[11], L0[9]));
        arrayList.add(EllipsoidIcosahedralTessellator.createTileFromAngles(globeInfo, 0, L0[20], L0[22], L0[11]));
        arrayList.add(EllipsoidIcosahedralTessellator.createTileFromAngles(globeInfo, 0, L0[22], L0[13], L0[11]));
        arrayList.add(EllipsoidIcosahedralTessellator.createTileFromAngles(globeInfo, 0, L0[22], L0[24], L0[13]));
        arrayList.add(EllipsoidIcosahedralTessellator.createTileFromAngles(globeInfo, 0, L0[24], L0[15], L0[13]));
        arrayList.add(EllipsoidIcosahedralTessellator.createTileFromAngles(globeInfo, 0, L0[24], L0[25], L0[15]));
        arrayList.add(EllipsoidIcosahedralTessellator.createTileFromAngles(globeInfo, 0, L0[33], L0[26], L0[32]));
        arrayList.add(EllipsoidIcosahedralTessellator.createTileFromAngles(globeInfo, 0, L0[27], L0[18], L0[16]));
        arrayList.add(EllipsoidIcosahedralTessellator.createTileFromAngles(globeInfo, 0, L0[28], L0[20], L0[18]));
        arrayList.add(EllipsoidIcosahedralTessellator.createTileFromAngles(globeInfo, 0, L0[29], L0[22], L0[20]));
        arrayList.add(EllipsoidIcosahedralTessellator.createTileFromAngles(globeInfo, 0, L0[30], L0[24], L0[22]));
        arrayList.add(EllipsoidIcosahedralTessellator.createTileFromAngles(globeInfo, 0, L0[25], L0[24], L0[31]));
        arrayList.add(EllipsoidIcosahedralTessellator.createTileFromAngles(globeInfo, 0, L0[26], L0[33], L0[34]));
        return arrayList;
    }

    public EllipsoidIcosahedralTessellator(Globe globe) {
        this.globe = globe;
        this.globeInfo = new GlobeInfo(this.globe);
        this.topLevels = EllipsoidIcosahedralTessellator.makeLevelZeroEquilateralTriangles(this.globeInfo);
    }

    public Sector getSector() {
        return this.sector;
    }

    @Override
    public SectorGeometryList tessellate(DrawContext drawContext) {
        View view = drawContext.getView();
        this.currentTiles.clear();
        this.currentLevel = 0;
        this.sector = null;
        this.currentFrustum = view.getFrustumInModelCoordinates();
        for (IcosaTile icosaTile : this.topLevels) {
            this.selectVisibleTiles(icosaTile, view);
        }
        drawContext.setVisibleSector(this.getSector());
        return this.currentTiles;
    }

    private boolean needToSplit(IcosaTile icosaTile, View view) {
        double d = view.getEyePoint().distanceTo(icosaTile.p0);
        double d2 = view.getEyePoint().distanceTo(icosaTile.p1);
        double d3 = view.getEyePoint().distanceTo(icosaTile.p2);
        double d4 = view.getEyePoint().distanceTo(icosaTile.pCentroid);
        double d5 = d;
        if (d2 < d5) {
            d5 = d2;
        }
        if (d3 < d5) {
            d5 = d3;
        }
        if (d4 < d5) {
            d5 = d4;
        }
        double d6 = view.computePixelSizeAtDistance(d5);
        return icosaTile.edgeLength / (double)this.density >= 30.0 * (2.0 * d6);
    }

    private void selectVisibleTiles(IcosaTile icosaTile, View view) {
        if (!icosaTile.getExtent().intersects(this.currentFrustum)) {
            return;
        }
        if (this.currentLevel < this.maxLevel && this.needToSplit(icosaTile, view)) {
            IcosaTile[] icosaTileArray;
            ++this.currentLevel;
            for (IcosaTile icosaTile2 : icosaTileArray = icosaTile.split()) {
                this.selectVisibleTiles(icosaTile2, view);
            }
            --this.currentLevel;
            return;
        }
        this.sector = icosaTile.getSector().union(this.sector);
        this.currentTiles.add(icosaTile);
    }

    static /* synthetic */ int access$000() {
        return DEFAULT_DENSITY;
    }

    private static class CacheKey {
        private final Point centroid;
        private int resolution;
        private final double verticalExaggeration;
        private int density;

        private CacheKey(IcosaTile icosaTile, int n, double d, int n2) {
            this.centroid = icosaTile.pCentroid;
            this.resolution = n;
            this.verticalExaggeration = d;
            this.density = n2;
        }

        public String toString() {
            return "density " + this.density + " ve " + this.verticalExaggeration + " resolution " + this.resolution;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)object;
            if (this.density != cacheKey.density) {
                return false;
            }
            if (this.resolution != cacheKey.resolution) {
                return false;
            }
            if (Double.compare(cacheKey.verticalExaggeration, this.verticalExaggeration) != 0) {
                return false;
            }
            return !(this.centroid != null ? !this.centroid.equals(cacheKey.centroid) : cacheKey.centroid != null);
        }

        public int hashCode() {
            int n = this.centroid != null ? this.centroid.hashCode() : 0;
            n = 31 * n + this.resolution;
            long l = this.verticalExaggeration != 0.0 ? Double.doubleToLongBits(this.verticalExaggeration) : 0L;
            n = 31 * n + (int)(l ^ l >>> 32);
            n = 31 * n + this.density;
            return n;
        }
    }

    private static class IcosaTile
    implements SectorGeometry {
        private static HashMap<Integer, double[]> parameterizations = new HashMap();
        private static HashMap<Integer, IntBuffer> indexLists = new HashMap();
        protected final int level;
        private final GlobeInfo globeInfo;
        private final LatLon g0;
        private final LatLon g1;
        private final LatLon g2;
        private Sector sector;
        protected final Point unitp0;
        protected final Point unitp1;
        protected final Point unitp2;
        private final Point p0;
        private final Point p1;
        private final Point p2;
        private final Point pCentroid;
        private final Cylinder extent;
        private final double edgeLength;
        private int density = EllipsoidIcosahedralTessellator.access$000();
        private long byteSize;
        static final double ROOT3_OVER4 = Math.sqrt(3.0) / 4.0;

        protected static double[] getParameterization(int n) {
            double[] dArray = parameterizations.get(n);
            if (dArray != null) {
                return dArray;
            }
            int n2 = (n * n + 3 * n + 2) / 2;
            dArray = new double[2 * n2];
            double d = 1.0 / (double)n;
            int n3 = 0;
            for (int i = 0; i <= n; ++i) {
                double d2 = (double)i * d;
                for (int j = 0; j <= n - i; ++j) {
                    dArray[n3++] = (double)j * d;
                    dArray[n3++] = d2;
                }
            }
            parameterizations.put(n, dArray);
            return dArray;
        }

        protected static IntBuffer getIndices(int n) {
            IntBuffer intBuffer = indexLists.get(n);
            if (intBuffer != null) {
                return intBuffer;
            }
            int n2 = n * n + 4 * n - 2;
            intBuffer = BufferUtil.newIntBuffer(n2);
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                int n4;
                intBuffer.put(n3);
                if (i > 0) {
                    n3 = intBuffer.get(intBuffer.position() - 3);
                    intBuffer.put(n3);
                    intBuffer.put(n3);
                }
                if (i % 2 == 0) {
                    for (n4 = 0; n4 < n - i; ++n4) {
                        intBuffer.put(++n3);
                        intBuffer.put(n3 += n - n4);
                    }
                    continue;
                }
                for (n4 = n - i - 1; n4 >= 0; --n4) {
                    intBuffer.put(n3 -= n - n4);
                    intBuffer.put(--n3);
                }
            }
            indexLists.put(n, intBuffer);
            return intBuffer;
        }

        public static Point getUnitPoint(double d, double d2, Point point, Point point2, Point point3) {
            double d3 = 1.0 - d - d2;
            double d4 = d * point2.x() + d2 * point3.x() + d3 * point.x();
            double d5 = d * point2.y() + d2 * point3.y() + d3 * point.y();
            double d6 = d * point2.z() + d2 * point3.z() + d3 * point.z();
            double d7 = 1.0 / Math.sqrt(d4 * d4 + d5 * d5 + d6 * d6);
            return new Point(d4 * d7, d5 * d7, d6 * d7);
        }

        public IcosaTile(GlobeInfo globeInfo, int n, Point point, Point point2, Point point3) {
            this.level = n;
            this.globeInfo = globeInfo;
            this.unitp0 = point;
            this.unitp1 = point2;
            this.unitp2 = point3;
            Angle angle = Angle.fromRadians(Math.asin(this.unitp0.y()));
            Angle angle2 = Angle.fromRadians(Math.atan2(this.unitp0.x(), this.unitp0.z()));
            this.g0 = new LatLon(angle, angle2);
            angle = Angle.fromRadians(Math.asin(this.unitp1.y()));
            angle2 = Angle.fromRadians(Math.atan2(this.unitp1.x(), this.unitp1.z()));
            this.g1 = new LatLon(angle, angle2);
            angle = Angle.fromRadians(Math.asin(this.unitp2.y()));
            angle2 = Angle.fromRadians(Math.atan2(this.unitp2.x(), this.unitp2.z()));
            this.g2 = new LatLon(angle, angle2);
            this.p0 = this.scaleUnitPointToEllipse(this.unitp0, this.globeInfo.invAsq, this.globeInfo.invCsq);
            this.p1 = this.scaleUnitPointToEllipse(this.unitp1, this.globeInfo.invAsq, this.globeInfo.invCsq);
            this.p2 = this.scaleUnitPointToEllipse(this.unitp2, this.globeInfo.invAsq, this.globeInfo.invCsq);
            double d = 0.3333333333333333;
            Point point4 = IcosaTile.getUnitPoint(d, d, this.unitp0, this.unitp1, this.unitp2);
            this.pCentroid = this.scaleUnitPointToEllipse(point4, this.globeInfo.invAsq, this.globeInfo.invCsq);
            this.extent = Sector.computeBoundingCylinder(globeInfo.globe, 1.0, this.getSector());
            this.edgeLength = this.globeInfo.level0EdgeLength / Math.pow(2.0, this.level);
        }

        public IcosaTile(GlobeInfo globeInfo, int n, LatLon latLon, LatLon latLon2, LatLon latLon3) {
            this.level = n;
            this.globeInfo = globeInfo;
            this.g0 = latLon;
            this.g1 = latLon2;
            this.g2 = latLon3;
            this.unitp0 = PolarPoint.toCartesian(this.g0.getLatitude(), this.g0.getLongitude(), 1.0);
            this.unitp1 = PolarPoint.toCartesian(this.g1.getLatitude(), this.g1.getLongitude(), 1.0);
            this.unitp2 = PolarPoint.toCartesian(this.g2.getLatitude(), this.g2.getLongitude(), 1.0);
            this.p0 = this.scaleUnitPointToEllipse(this.unitp0, this.globeInfo.invAsq, this.globeInfo.invCsq);
            this.p1 = this.scaleUnitPointToEllipse(this.unitp1, this.globeInfo.invAsq, this.globeInfo.invCsq);
            this.p2 = this.scaleUnitPointToEllipse(this.unitp2, this.globeInfo.invAsq, this.globeInfo.invCsq);
            double d = 0.3333333333333333;
            Point point = IcosaTile.getUnitPoint(d, d, this.unitp0, this.unitp1, this.unitp2);
            this.pCentroid = this.scaleUnitPointToEllipse(point, this.globeInfo.invAsq, this.globeInfo.invCsq);
            this.extent = Sector.computeBoundingCylinder(globeInfo.globe, 1.0, this.getSector());
            this.edgeLength = this.globeInfo.level0EdgeLength / Math.pow(2.0, this.level);
        }

        public Sector getSector() {
            if (this.sector != null) {
                return this.sector;
            }
            double d = this.g0.getLatitude().getRadians();
            if (this.g1.getLatitude().getRadians() < d) {
                d = this.g1.getLatitude().getRadians();
            }
            if (this.g2.getLatitude().getRadians() < d) {
                d = this.g2.getLatitude().getRadians();
            }
            Angle angle = Angle.fromRadians(d);
            d = this.g0.getLatitude().getRadians();
            if (this.g1.getLatitude().getRadians() > d) {
                d = this.g1.getLatitude().getRadians();
            }
            if (this.g2.getLatitude().getRadians() > d) {
                d = this.g2.getLatitude().getRadians();
            }
            Angle angle2 = Angle.fromRadians(d);
            d = this.g0.getLongitude().getRadians();
            if (this.g1.getLongitude().getRadians() < d) {
                d = this.g1.getLongitude().getRadians();
            }
            if (this.g2.getLongitude().getRadians() < d) {
                d = this.g2.getLongitude().getRadians();
            }
            Angle angle3 = Angle.fromRadians(d);
            d = this.g0.getLongitude().getRadians();
            if (this.g1.getLongitude().getRadians() > d) {
                d = this.g1.getLongitude().getRadians();
            }
            if (this.g2.getLongitude().getRadians() > d) {
                d = this.g2.getLongitude().getRadians();
            }
            Angle angle4 = Angle.fromRadians(d);
            this.sector = new Sector(angle, angle2, angle3, angle4);
            return this.sector;
        }

        private Point scaleUnitPointToEllipse(Point point, double d, double d2) {
            double d3 = point.x() * point.x() * d + point.y() * point.y() * d2 + point.z() * point.z() * d;
            d3 = 1.0 / Math.sqrt(d3);
            return new Point(point.x() * d3, point.y() * d3, point.z() * d3);
        }

        private IcosaTile[] split() {
            Point point = Point.midPoint(this.p0, this.p1);
            Point point2 = Point.midPoint(this.p1, this.p2);
            Point point3 = Point.midPoint(this.p2, this.p0);
            point = point.multiply(1.0 / point.length());
            point2 = point2.multiply(1.0 / point2.length());
            point3 = point3.multiply(1.0 / point3.length());
            IcosaTile[] icosaTileArray = new IcosaTile[]{new IcosaTile(this.globeInfo, this.level + 1, this.unitp0, point, point3), new IcosaTile(this.globeInfo, this.level + 1, point, this.unitp1, point2), new IcosaTile(this.globeInfo, this.level + 1, point3, point2, this.unitp2), new IcosaTile(this.globeInfo, this.level + 1, point2, point3, point)};
            return icosaTileArray;
        }

        public String toString() {
            return this.level + ": (" + this.unitp0.toString() + ", " + this.unitp1.toString() + ", " + this.unitp2.toString() + ")";
        }

        public Extent getExtent() {
            return this.extent;
        }

        private RenderInfo makeVerts(DrawContext drawContext, int n) {
            ElevationModel elevationModel = drawContext.getGlobe().getElevationModel();
            int n2 = elevationModel.getTargetResolution(drawContext, this.getSector(), n);
            CacheKey cacheKey = new CacheKey(this, n2, drawContext.getVerticalExaggeration(), n);
            RenderInfo renderInfo = (RenderInfo)WorldWind.memoryCache().getObject(cacheKey);
            if (renderInfo != null) {
                return renderInfo;
            }
            renderInfo = this.buildVerts(drawContext, n2);
            this.byteSize = renderInfo.getSizeInBytes();
            WorldWind.memoryCache().add(cacheKey, renderInfo, this.byteSize);
            return renderInfo;
        }

        private RenderInfo buildVerts(DrawContext drawContext, int n) {
            double[] dArray = IcosaTile.getParameterization(this.density);
            int n2 = dArray.length + dArray.length / 2;
            int n3 = dArray.length;
            DoubleBuffer doubleBuffer = BufferUtil.newDoubleBuffer(n2);
            DoubleBuffer doubleBuffer2 = BufferUtil.newDoubleBuffer(n3);
            ElevationModel.Elevations elevations = drawContext.getGlobe().getElevationModel().getElevations(this.getSector(), n);
            Point point = this.unitp1;
            Point point2 = this.unitp2;
            Point point3 = this.unitp0;
            int n4 = 0;
            while (doubleBuffer.hasRemaining()) {
                double d = dArray[n4++];
                double d2 = dArray[n4++];
                double d3 = 1.0 - d - d2;
                double d4 = d * point.x() + d2 * point2.x() + d3 * point3.x();
                double d5 = d * point.y() + d2 * point2.y() + d3 * point3.y();
                double d6 = d * point.z() + d2 * point2.z() + d3 * point3.z();
                double d7 = Math.atan2(d5, Math.sqrt(d4 * d4 + d6 * d6));
                double d8 = Math.atan2(d4, d6);
                double d9 = 1.0 / Math.sqrt(d4 * d4 * this.globeInfo.invAsq + d5 * d5 * this.globeInfo.invCsq + d6 * d6 * this.globeInfo.invAsq);
                double d10 = elevations.getElevation(d7, d8);
                double d11 = 2.0 * (d4 *= d9) * this.globeInfo.invAsq;
                double d12 = 2.0 * (d5 *= d9) * this.globeInfo.invCsq;
                double d13 = 2.0 * (d6 *= d9) * this.globeInfo.invAsq;
                double d14 = d10 * drawContext.getVerticalExaggeration() / Math.sqrt(d11 * d11 + d12 * d12 + d13 * d13);
                d7 = Math.atan2(d5, Math.sqrt(d4 * d4 + d6 * d6));
                d8 = Math.atan2(d4, d6);
                doubleBuffer.put(d4 += (d11 *= d14) - this.pCentroid.getX()).put(d5 += (d12 *= d14) - this.pCentroid.getY()).put(d6 += (d13 *= d14) - this.pCentroid.getZ());
                doubleBuffer2.put(d8).put(d7);
            }
            doubleBuffer.rewind();
            return new RenderInfo(this.density, doubleBuffer, doubleBuffer2);
        }

        public void renderMultiTexture(DrawContext drawContext, int n) {
            this.render(drawContext, this.density, n);
        }

        public void render(DrawContext drawContext) {
            this.render(drawContext, this.density, 1);
        }

        private long render(DrawContext drawContext, int n, int n2) {
            RenderInfo renderInfo = this.makeVerts(drawContext, n);
            IntBuffer intBuffer = IcosaTile.getIndices(renderInfo.density);
            intBuffer.rewind();
            drawContext.getView().pushReferenceCenter(drawContext, this.pCentroid);
            GL gL = drawContext.getGL();
            gL.glPushClientAttrib(2);
            gL.glEnableClientState(32884);
            gL.glVertexPointer(3, 5130, 0, renderInfo.vertices.rewind());
            for (int i = 0; i < n2; ++i) {
                gL.glClientActiveTexture(33984 + i);
                gL.glEnableClientState(32888);
                gL.glTexCoordPointer(2, 5130, 0, renderInfo.texCoords.rewind());
            }
            gL.glDrawElements(5, intBuffer.limit(), 5125, intBuffer.rewind());
            gL.glPopClientAttrib();
            drawContext.getView().popReferenceCenter(drawContext);
            return intBuffer.limit() - 2;
        }

        public void renderWireframe(DrawContext drawContext, boolean bl, boolean bl2) {
            RenderInfo renderInfo = this.makeVerts(drawContext, this.density);
            IntBuffer intBuffer = IcosaTile.getIndices(renderInfo.density);
            intBuffer.rewind();
            drawContext.getView().pushReferenceCenter(drawContext, this.pCentroid);
            GL gL = drawContext.getGL();
            gL.glPushAttrib(270601);
            gL.glEnable(3042);
            gL.glBlendFunc(770, 1);
            gL.glDisable(2929);
            gL.glEnable(2884);
            gL.glCullFace(1029);
            gL.glDisable(3553);
            gL.glColor4d(1.0, 1.0, 1.0, 0.2);
            gL.glPolygonMode(1028, 6913);
            if (bl) {
                gL.glPushClientAttrib(2);
                gL.glEnableClientState(32884);
                gL.glVertexPointer(3, 5130, 0, renderInfo.vertices);
                gL.glDrawElements(5, intBuffer.limit(), 5125, intBuffer);
                gL.glPopClientAttrib();
            }
            drawContext.getView().popReferenceCenter(drawContext);
            if (bl2) {
                this.renderPatchBoundary(gL);
            }
            gL.glPopAttrib();
        }

        private void renderPatchBoundary(GL gL) {
            gL.glColor4d(1.0, 0.0, 0.0, 1.0);
            gL.glBegin(4);
            gL.glVertex3d(this.p0.x(), this.p0.y(), this.p0.z());
            gL.glVertex3d(this.p1.x(), this.p1.y(), this.p1.z());
            gL.glVertex3d(this.p2.x(), this.p2.y(), this.p2.z());
            gL.glEnd();
        }

        public void renderBoundingVolume(DrawContext drawContext) {
        }

        public void renderBoundary(DrawContext drawContext) {
            this.renderWireframe(drawContext, false, true);
        }

        public Point getSurfacePoint(Angle angle, Angle angle2, double d) {
            return this.globeInfo.globe.computePointFromPosition(angle, angle2, d);
        }

        public void pick(DrawContext drawContext, java.awt.Point point) {
        }

        public long getSizeInBytes() {
            return this.byteSize;
        }

        public int compareTo(SectorGeometry sectorGeometry) {
            if (sectorGeometry == null) {
                String string = WorldWind.retrieveErrMsg("nullValue.GeometryIsNull");
                WorldWind.logger().log(Level.FINE, string);
                throw new IllegalArgumentException(string);
            }
            return this.getSector().compareTo(sectorGeometry.getSector());
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            IcosaTile icosaTile = (IcosaTile)object;
            if (this.density != icosaTile.density) {
                return false;
            }
            if (this.level != icosaTile.level) {
                return false;
            }
            if (this.g0 != null ? !this.g0.equals(icosaTile.g0) : icosaTile.g0 != null) {
                return false;
            }
            if (this.g1 != null ? !this.g1.equals(icosaTile.g1) : icosaTile.g1 != null) {
                return false;
            }
            if (this.g2 != null ? !this.g2.equals(icosaTile.g2) : icosaTile.g2 != null) {
                return false;
            }
            if (this.globeInfo != null ? !this.globeInfo.equals(icosaTile.globeInfo) : icosaTile.globeInfo != null) {
                return false;
            }
            if (this.p0 != null ? !this.p0.equals(icosaTile.p0) : icosaTile.p0 != null) {
                return false;
            }
            if (this.p1 != null ? !this.p1.equals(icosaTile.p1) : icosaTile.p1 != null) {
                return false;
            }
            if (this.p2 != null ? !this.p2.equals(icosaTile.p2) : icosaTile.p2 != null) {
                return false;
            }
            if (this.getSector() != null ? !this.getSector().equals(icosaTile.getSector()) : icosaTile.getSector() != null) {
                return false;
            }
            if (this.unitp0 != null ? !this.unitp0.equals(icosaTile.unitp0) : icosaTile.unitp0 != null) {
                return false;
            }
            if (this.unitp1 != null ? !this.unitp1.equals(icosaTile.unitp1) : icosaTile.unitp1 != null) {
                return false;
            }
            return !(this.unitp2 != null ? !this.unitp2.equals(icosaTile.unitp2) : icosaTile.unitp2 != null);
        }

        public int hashCode() {
            int n = this.level;
            n = 31 * n + (this.globeInfo != null ? this.globeInfo.hashCode() : 0);
            n = 31 * n + (this.g0 != null ? this.g0.hashCode() : 0);
            n = 31 * n + (this.g1 != null ? this.g1.hashCode() : 0);
            n = 31 * n + (this.g2 != null ? this.g2.hashCode() : 0);
            n = 31 * n + this.getSector().hashCode();
            n = 31 * n + (this.unitp0 != null ? this.unitp0.hashCode() : 0);
            n = 31 * n + (this.unitp1 != null ? this.unitp1.hashCode() : 0);
            n = 31 * n + (this.unitp2 != null ? this.unitp2.hashCode() : 0);
            n = 31 * n + (this.p0 != null ? this.p0.hashCode() : 0);
            n = 31 * n + (this.p1 != null ? this.p1.hashCode() : 0);
            n = 31 * n + (this.p2 != null ? this.p2.hashCode() : 0);
            n = 31 * n + this.density;
            return n;
        }

        private static class RenderInfo {
            private final int density;
            private DoubleBuffer vertices;
            private final DoubleBuffer texCoords;

            private RenderInfo(int n, DoubleBuffer doubleBuffer, DoubleBuffer doubleBuffer2) {
                this.density = n;
                this.vertices = doubleBuffer;
                this.texCoords = doubleBuffer2;
            }

            private long getSizeInBytes() {
                return 12L;
            }
        }
    }

    private static class GlobeInfo {
        private final Globe globe;
        private final double level0EdgeLength;
        private final double invAsq;
        private final double invCsq;
        static final double EDGE_FACTOR = Math.sqrt(10.0 + 2.0 * Math.sqrt(5.0)) / 4.0;

        private GlobeInfo(Globe globe) {
            this.globe = globe;
            double d = globe.getEquatorialRadius();
            double d2 = globe.getPolarRadius();
            this.invAsq = 1.0 / (d * d);
            this.invCsq = 1.0 / (d2 * d2);
            this.level0EdgeLength = d / EDGE_FACTOR;
        }
    }
}

