/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.globes;

import gov.nasa.worldwind.ElevationModel;
import gov.nasa.worldwind.Globe;
import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.Frustum;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Plane;
import gov.nasa.worldwind.geom.Point;
import gov.nasa.worldwind.geom.Position;
import java.util.logging.Level;

public class EllipsoidalGlobe
extends WWObjectImpl
implements Globe {
    private final double equatorialRadius;
    private final double polarRadius;
    private final double es;
    private final Point center;
    private final ElevationModel elevationModel;

    public EllipsoidalGlobe(double d, double d2, double d3, ElevationModel elevationModel) {
        if (elevationModel == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.ElevationModelIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.equatorialRadius = d;
        this.polarRadius = d2;
        this.es = d3;
        this.center = Point.ZERO;
        this.elevationModel = elevationModel;
    }

    public final double getRadius() {
        return this.equatorialRadius;
    }

    public final double getEquatorialRadius() {
        return this.equatorialRadius;
    }

    public final double getPolarRadius() {
        return this.polarRadius;
    }

    public double getMaximumRadius() {
        return this.equatorialRadius;
    }

    public double getRadiusAt(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.AngleIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        return this.computePointFromPosition(angle, angle2, 0.0).length();
    }

    public double getEccentricitySquared() {
        return this.es;
    }

    public final double getDiameter() {
        return this.equatorialRadius * 2.0;
    }

    public final Point getCenter() {
        return this.center;
    }

    public double getMaxElevation() {
        return this.elevationModel.getMaximumElevation();
    }

    public double getMinElevation() {
        return this.elevationModel.getMinimumElevation();
    }

    public final Extent getExtent() {
        return this;
    }

    public boolean intersects(Frustum frustum) {
        if (frustum == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.FrustumIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        return frustum.intersects(this);
    }

    public Intersection[] intersect(Line line) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        if (line == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.LineIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        double d8 = this.equatorialRadius / this.polarRadius;
        double d9 = 1.0;
        double d10 = d8 * d8;
        double d11 = d9 * d9;
        double d12 = line.getDirection().getX();
        double d13 = d12 * d12 + d10 * (d7 = line.getDirection().getY()) * d7 + d11 * (d6 = line.getDirection().getZ()) * d6;
        double d14 = EllipsoidalGlobe.discriminant(d13, d5 = 2.0 * ((d4 = line.getOrigin().getX()) * d12 + d10 * (d3 = line.getOrigin().getY()) * d7 + d11 * (d2 = line.getOrigin().getZ()) * d6), d = d4 * d4 + d10 * d3 * d3 + d11 * d2 * d2 - this.equatorialRadius * this.equatorialRadius);
        if (d14 < 0.0) {
            return null;
        }
        double d15 = Math.sqrt(d14);
        if (d14 == 0.0) {
            Point point = line.getPointAt((-d5 - d15) / (2.0 * d13));
            return new Intersection[]{new Intersection(point, true)};
        }
        Point point = line.getPointAt((-d5 - d15) / (2.0 * d13));
        Point point2 = line.getPointAt((-d5 + d15) / (2.0 * d13));
        return new Intersection[]{new Intersection(point, false), new Intersection(point2, false)};
    }

    private static double discriminant(double d, double d2, double d3) {
        return d2 * d2 - 4.0 * d * d3;
    }

    public boolean intersects(Line line) {
        if (line == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.LineIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        return line.distanceTo(this.center) <= this.equatorialRadius;
    }

    public boolean intersects(Plane plane) {
        if (plane == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.PlaneIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        double d = plane.dot(this.center);
        return d <= this.equatorialRadius;
    }

    public Point computeSurfaceNormalAtPoint(Point point) {
        if (point == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.PointIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        point = point.subtract(this.center);
        return new Point(point.x() / (this.equatorialRadius * this.equatorialRadius), point.y() / (this.polarRadius * this.polarRadius), point.z() / (this.equatorialRadius * this.equatorialRadius)).normalize();
    }

    public final ElevationModel getElevationModel() {
        return this.elevationModel;
    }

    public final double getElevation(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.LatitudeOrLongitudeIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        return this.elevationModel != null ? this.elevationModel.getElevation(angle, angle2) : 0.0;
    }

    public final Point computePointFromPosition(Position position) {
        if (position == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.PositionIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        return this.geodeticToCartesian(position.getLatitude(), position.getLongitude(), position.getElevation());
    }

    public final Point computePointFromPosition(Angle angle, Angle angle2, double d) {
        if (angle == null || angle2 == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.LatitudeOrLongitudeIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        return this.geodeticToCartesian(angle, angle2, d);
    }

    public final Position computePositionFromPoint(Point point) {
        if (point == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.PointIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        return this.cartesianToGeodetic(point);
    }

    public final Position getIntersectionPosition(Line line) {
        if (line == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.LineIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        Intersection[] intersectionArray = this.intersect(line);
        if (intersectionArray == null) {
            return null;
        }
        return this.computePositionFromPoint(intersectionArray[0].getIntersectionPoint());
    }

    private Point geodeticToCartesian(Angle angle, Angle angle2, double d) {
        if (angle == null || angle2 == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.LatitudeOrLongitudeIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        double d2 = angle.cos();
        double d3 = angle.sin();
        double d4 = this.equatorialRadius / Math.sqrt(1.0 - this.es * d3 * d3);
        double d5 = (d4 + d) * d2 * angle2.sin();
        double d6 = (d4 * (1.0 - this.es) + d) * d3;
        double d7 = (d4 + d) * d2 * angle2.cos();
        return new Point(d5, d6, d7);
    }

    private Position cartesianToGeodetic(Point point) {
        if (point == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.PointIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        double d = 1.0 / (this.equatorialRadius * this.equatorialRadius);
        double d2 = point.z();
        double d3 = point.x();
        double d4 = point.y();
        double d5 = this.es;
        double d6 = d5 * d5;
        double d7 = d2 * d2 + d3 * d3;
        double d8 = Math.sqrt(d7);
        double d9 = d7 * d;
        double d10 = d4 * d4 * (1.0 - d5) * d;
        double d11 = 0.16666666666666666 * (d9 + d10 - d6);
        double d12 = d6 * d9 * d10 / (4.0 * d11 * d11 * d11);
        double d13 = Math.pow(1.0 + d12 + Math.sqrt(d12 * (2.0 + d12)), 0.3333333333333333);
        double d14 = d11 * (1.0 + d13 + 1.0 / d13);
        double d15 = Math.sqrt(d14 * d14 + d6 * d10);
        double d16 = d5 * (d14 + d15 - d10) / (2.0 * d15);
        double d17 = Math.sqrt(d14 + d15 + d16 * d16) - d16;
        double d18 = d17 * d8 / (d17 + d5);
        double d19 = 2.0 * Math.atan2(d3, d2 + d8);
        double d20 = Math.sqrt(d18 * d18 + d4 * d4);
        double d21 = 2.0 * Math.atan2(d4, d18 + d20);
        double d22 = (d17 + d5 - 1.0) * d20 / d17;
        return Position.fromRadians(d21, d19, d22);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        EllipsoidalGlobe ellipsoidalGlobe = (EllipsoidalGlobe)object;
        if (Double.compare(ellipsoidalGlobe.equatorialRadius, this.equatorialRadius) != 0) {
            return false;
        }
        if (Double.compare(ellipsoidalGlobe.es, this.es) != 0) {
            return false;
        }
        if (Double.compare(ellipsoidalGlobe.polarRadius, this.polarRadius) != 0) {
            return false;
        }
        if (this.center != null ? !this.center.equals(ellipsoidalGlobe.center) : ellipsoidalGlobe.center != null) {
            return false;
        }
        return !(this.elevationModel != null ? !this.elevationModel.equals(ellipsoidalGlobe.elevationModel) : ellipsoidalGlobe.elevationModel != null);
    }

    public int hashCode() {
        long l = this.equatorialRadius != 0.0 ? Double.doubleToLongBits(this.equatorialRadius) : 0L;
        int n = (int)(l ^ l >>> 32);
        l = this.polarRadius != 0.0 ? Double.doubleToLongBits(this.polarRadius) : 0L;
        n = 31 * n + (int)(l ^ l >>> 32);
        l = this.es != 0.0 ? Double.doubleToLongBits(this.es) : 0L;
        n = 31 * n + (int)(l ^ l >>> 32);
        n = 31 * n + (this.center != null ? this.center.hashCode() : 0);
        n = 31 * n + (this.elevationModel != null ? this.elevationModel.hashCode() : 0);
        return n;
    }
}

