/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers;

import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureCoords;
import com.sun.opengl.util.texture.TextureIO;
import gov.nasa.worldwind.DrawContext;
import gov.nasa.worldwind.WWRuntimeException;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.geom.Point;
import gov.nasa.worldwind.layers.AbstractLayer;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import javax.media.opengl.GL;

public class CompassLayer
extends AbstractLayer {
    public static final String NORTHWEST = "gov.nasa.worldwind.CompassLayer.NorthWest";
    public static final String SOUTHWEST = "gov.nasa.worldwind.CompassLayer.SouthWest";
    public static final String NORTHEAST = "gov.nasa.worldwind.CompassLayer.NorthEast";
    public static final String SOUTHEAST = "gov.nasa.worldwind.CompassLayer.SouthEast";
    public static final String RESIZE_STRETCH = "gov.nasa.worldwind.CompassLayer.ResizeStretch";
    public static final String RESIZE_SHRINK_ONLY = "gov.nasa.worldwind.CompassLayer.ResizeShrinkOnly";
    public static final String RESIZE_KEEP_FIXED_SIZE = "gov.nasa.worldwind.CompassLayer.ResizeKeepFixedSize";
    private String iconFilePath = "images/notched-compass.png";
    private double compassToViewportScale = 0.2;
    private double iconScale = 0.5;
    private int borderWidth = 20;
    private String position = "gov.nasa.worldwind.CompassLayer.NorthEast";
    private String resizeBehavior = "gov.nasa.worldwind.CompassLayer.ResizeShrinkOnly";
    private Texture iconTexture = null;
    private Point locationCenter = null;
    private boolean showTilt = false;

    public CompassLayer() {
        this.setOpacity(0.8);
    }

    public CompassLayer(String string) {
        this.setIconFilePath(string);
        this.setOpacity(0.8);
    }

    public String getIconFilePath() {
        return this.iconFilePath;
    }

    public void setIconFilePath(String string) {
        if (string == null) {
            String string2 = WorldWind.retrieveErrMsg("nullValue.IconFilePath");
            WorldWind.logger().log(Level.FINE, string2);
            throw new IllegalArgumentException(string2);
        }
        this.iconFilePath = string;
    }

    public double getCompassToViewportScale() {
        return this.compassToViewportScale;
    }

    public void setCompassToViewportScale(double d) {
        this.compassToViewportScale = d;
    }

    public double getIconScale() {
        return this.iconScale;
    }

    public void setIconScale(double d) {
        this.iconScale = d;
    }

    public String getResizeBehavior() {
        return this.resizeBehavior;
    }

    public void setResizeBehavior(String string) {
        this.resizeBehavior = string;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(int n) {
        this.borderWidth = n;
    }

    public String getPosition() {
        return this.position;
    }

    public void setPosition(String string) {
        if (string == null) {
            String string2 = WorldWind.retrieveErrMsg("nullValue.CompassPositionIsNull");
            WorldWind.logger().log(Level.FINE, string2);
            throw new IllegalArgumentException(string2);
        }
        this.position = string;
    }

    public Point getLocationCenter() {
        return this.locationCenter;
    }

    public void setLocationCenter(Point point) {
        this.locationCenter = point;
    }

    protected void doRender(DrawContext drawContext) {
        this.drawIcon(drawContext);
    }

    public boolean isShowTilt() {
        return this.showTilt;
    }

    public void setShowTilt(boolean bl) {
        this.showTilt = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawIcon(DrawContext drawContext) {
        if (this.iconFilePath == null) {
            return;
        }
        GL gL = drawContext.getGL();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            gL.glPushAttrib(293121);
            bl = true;
            if (this.iconTexture == null) {
                this.initializeTexture(drawContext);
            }
            gL.glEnable(3553);
            this.iconTexture.bind();
            gL.glColor4d(1.0, 1.0, 1.0, this.getOpacity());
            gL.glEnable(3042);
            gL.glBlendFunc(770, 771);
            gL.glDisable(2929);
            double d = this.getScaledIconWidth();
            double d2 = this.getScaledIconHeight();
            Rectangle rectangle = drawContext.getView().getViewport();
            gL.glMatrixMode(5889);
            gL.glPushMatrix();
            bl3 = true;
            gL.glLoadIdentity();
            double d3 = d > d2 ? d : d2;
            gL.glOrtho(0.0, rectangle.width, 0.0, rectangle.height, -0.6 * d3, 0.6 * d3);
            gL.glMatrixMode(5888);
            gL.glPushMatrix();
            bl2 = true;
            gL.glLoadIdentity();
            double d4 = this.computeScale(rectangle);
            Point point = this.computeLocation(rectangle, d4);
            gL.glTranslated(point.x(), point.y(), point.z());
            gL.glScaled(d4, d4, 1.0);
            gL.glTranslated(d / 2.0, d2 / 2.0, 0.0);
            if (this.showTilt) {
                gL.glRotated(70.0 * (drawContext.getView().getPitch().getDegrees() / 90.0), 1.0, 0.0, 0.0);
            }
            gL.glRotated(drawContext.getView().getHeading().getDegrees(), 0.0, 0.0, 1.0);
            gL.glTranslated(-d / 2.0, -d2 / 2.0, 0.0);
            TextureCoords textureCoords = this.iconTexture.getImageTexCoords();
            gL.glScaled(d, d2, 1.0);
            drawContext.drawUnitQuad(textureCoords);
        }
        finally {
            if (bl3) {
                gL.glMatrixMode(5889);
                gL.glPopMatrix();
            }
            if (bl2) {
                gL.glMatrixMode(5888);
                gL.glPopMatrix();
            }
            if (bl) {
                gL.glPopAttrib();
            }
        }
    }

    private double computeScale(Rectangle rectangle) {
        if (this.resizeBehavior.equals(RESIZE_SHRINK_ONLY)) {
            return Math.min(1.0, this.compassToViewportScale * (double)rectangle.width / this.getScaledIconWidth());
        }
        if (this.resizeBehavior.equals(RESIZE_STRETCH)) {
            return this.compassToViewportScale * (double)rectangle.width / this.getScaledIconWidth();
        }
        if (this.resizeBehavior.equals(RESIZE_KEEP_FIXED_SIZE)) {
            return 1.0;
        }
        return 1.0;
    }

    private double getScaledIconWidth() {
        return (double)this.iconTexture.getWidth() * this.iconScale;
    }

    private double getScaledIconHeight() {
        return (double)this.iconTexture.getHeight() * this.iconScale;
    }

    private Point computeLocation(Rectangle rectangle, double d) {
        double d2;
        double d3;
        double d4 = this.getScaledIconWidth();
        double d5 = this.getScaledIconHeight();
        double d6 = d * d4;
        double d7 = d * d5;
        if (this.locationCenter != null) {
            d3 = rectangle.getWidth() - d6 / 2.0 - (double)this.borderWidth;
            d2 = rectangle.getHeight() - d7 / 2.0 - (double)this.borderWidth;
        } else if (this.position.equals(NORTHEAST)) {
            d3 = rectangle.getWidth() - d6 - (double)this.borderWidth;
            d2 = rectangle.getHeight() - d7 - (double)this.borderWidth;
        } else if (this.position.equals(SOUTHEAST)) {
            d3 = rectangle.getWidth() - d6 - (double)this.borderWidth;
            d2 = 0.0 + (double)this.borderWidth;
        } else if (this.position.equals(NORTHWEST)) {
            d3 = 0.0 + (double)this.borderWidth;
            d2 = rectangle.getHeight() - d7 - (double)this.borderWidth;
        } else if (this.position.equals(SOUTHWEST)) {
            d3 = 0.0 + (double)this.borderWidth;
            d2 = 0.0 + (double)this.borderWidth;
        } else {
            d3 = rectangle.getWidth() - d6 / 2.0 - (double)this.borderWidth;
            d2 = rectangle.getHeight() - d7 / 2.0 - (double)this.borderWidth;
        }
        return new Point(d3, d2, 0.0);
    }

    private void initializeTexture(DrawContext drawContext) {
        Object object;
        Object object2;
        if (this.iconTexture != null) {
            return;
        }
        try {
            object2 = this.getClass().getResourceAsStream("/" + this.iconFilePath);
            if (object2 == null && ((File)(object = new File(this.iconFilePath))).exists()) {
                object2 = new FileInputStream((File)object);
            }
            this.iconTexture = TextureIO.newTexture((InputStream)object2, true, null);
            this.iconTexture.bind();
        }
        catch (IOException iOException) {
            String string = WorldWind.retrieveErrMsg("layers.TrackLayer.IOExceptionDuringInitialization");
            WorldWind.logger().log(Level.FINE, string);
            throw new WWRuntimeException(string, iOException);
        }
        object2 = drawContext.getGL();
        object2.glTexEnvf(8960, 8704, 8448.0f);
        object2.glTexParameteri(3553, 10241, 9987);
        object2.glTexParameteri(3553, 10240, 9729);
        object2.glTexParameteri(3553, 10242, 33071);
        object2.glTexParameteri(3553, 10243, 33071);
        object = new int[1];
        object2.glGetIntegerv(34047, (int[])object, 0);
        object2.glTexParameteri(3553, 34046, (int)object[0]);
    }

    public String toString() {
        return WorldWind.retrieveErrMsg("layers.CompassLayer.Name");
    }
}

