/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers.Earth;

import gov.nasa.worldwind.AVListImpl;
import gov.nasa.worldwind.LevelSet;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.TiledImageLayer;

public class BMNGSurfaceLayer
extends TiledImageLayer {
    public BMNGSurfaceLayer() {
        super(BMNGSurfaceLayer.makeLevels());
        this.setForceLevelZeroLoads(true);
        this.setRetainLevelZeroTiles(true);
    }

    private static LevelSet makeLevels() {
        AVListImpl aVListImpl = new AVListImpl();
        aVListImpl.setValue("gov.nasa.worldwind.Level.TileWidthKey", 512);
        aVListImpl.setValue("gov.nasa.worldwind.Level.TileHeightKey", 512);
        aVListImpl.setValue("gov.nasa.worldwind.Level.CacheNameKey", "Earth/BMNG/BMNG(Shaded + Bathymetry) Tiled - Version 1.1 - 5.2004");
        aVListImpl.setValue("gov.nasa.worldwind.Level.ServiceURLKey", "http://worldwind25.arc.nasa.gov/tile/tile.aspx");
        aVListImpl.setValue("gov.nasa.worldwind.Level.DatasetNameKey", "bmng.topo.bathy.200405dds");
        aVListImpl.setValue("gov.nasa.worldwind.Level.FormatSuffixKey", ".dds");
        aVListImpl.setValue("gov.nasa.worldwind.Level.NumLevels", 5);
        aVListImpl.setValue("gov.nasa.worldwind.Level.NumEmptyLevels", 0);
        aVListImpl.setValue("gov.nasa.worldwind.Level.LevelZeroTileDelta", new LatLon(Angle.fromDegrees(36.0), Angle.fromDegrees(36.0)));
        aVListImpl.setValue("gov.nasa.worldwind.avKey.Sector", Sector.FULL_SPHERE);
        return new LevelSet(aVListImpl);
    }

    public String toString() {
        return WorldWind.retrieveErrMsg("layers.Earth.BlueMarbleLayer.Name");
    }
}

