/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers.Earth;

import gov.nasa.worldwind.AVListImpl;
import gov.nasa.worldwind.Level;
import gov.nasa.worldwind.LevelSet;
import gov.nasa.worldwind.Tile;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.TiledImageLayer;
import java.net.MalformedURLException;
import java.net.URL;

public class PoliticalBoundariesLayer
extends TiledImageLayer {
    public PoliticalBoundariesLayer() {
        super(PoliticalBoundariesLayer.makeLevels(new URLBuilder()));
        this.setUseTransparentTextures(true);
    }

    private static LevelSet makeLevels(URLBuilder uRLBuilder) {
        AVListImpl aVListImpl = new AVListImpl();
        aVListImpl.setValue("gov.nasa.worldwind.Level.TileWidthKey", 512);
        aVListImpl.setValue("gov.nasa.worldwind.Level.TileHeightKey", 512);
        aVListImpl.setValue("gov.nasa.worldwind.Level.CacheNameKey", "Earth/PoliticalBoundaries");
        aVListImpl.setValue("gov.nasa.worldwind.Level.ServiceURLKey", "http://worldwind21.arc.nasa.gov/geoserver/wms");
        aVListImpl.setValue("gov.nasa.worldwind.Level.DatasetNameKey", "topp:cia");
        aVListImpl.setValue("gov.nasa.worldwind.Level.FormatSuffixKey", ".png");
        aVListImpl.setValue("gov.nasa.worldwind.Level.NumLevels", 13);
        aVListImpl.setValue("gov.nasa.worldwind.Level.NumEmptyLevels", 0);
        aVListImpl.setValue("gov.nasa.worldwind.Level.LevelZeroTileDelta", new LatLon(Angle.fromDegrees(36.0), Angle.fromDegrees(36.0)));
        aVListImpl.setValue("gov.nasa.worldwind.avKey.Sector", Sector.FULL_SPHERE);
        aVListImpl.setValue("gov.nasa.worldwind.Level.TileURLBuilder", uRLBuilder);
        return new LevelSet(aVListImpl);
    }

    public String toString() {
        return WorldWind.retrieveErrMsg("layers.Earth.PoliticalBoundaries.Name");
    }

    private static class URLBuilder
    implements Level.TileURLBuilder {
        private URLBuilder() {
        }

        public URL getURL(Tile tile) throws MalformedURLException {
            StringBuffer stringBuffer = new StringBuffer(tile.getLevel().getService());
            if (stringBuffer.lastIndexOf("?") != stringBuffer.length() - 1) {
                stringBuffer.append("?");
            }
            stringBuffer.append("request=GetMap");
            stringBuffer.append("&layers=");
            stringBuffer.append(tile.getLevel().getDataset());
            stringBuffer.append("&srs=EPSG:4326");
            stringBuffer.append("&width=");
            stringBuffer.append(tile.getLevel().getTileWidth());
            stringBuffer.append("&height=");
            stringBuffer.append(tile.getLevel().getTileHeight());
            Sector sector = tile.getSector();
            stringBuffer.append("&bbox=");
            stringBuffer.append(sector.getMinLongitude().getDegrees());
            stringBuffer.append(",");
            stringBuffer.append(sector.getMinLatitude().getDegrees());
            stringBuffer.append(",");
            stringBuffer.append(sector.getMaxLongitude().getDegrees());
            stringBuffer.append(",");
            stringBuffer.append(sector.getMaxLatitude().getDegrees());
            stringBuffer.append("&format=image/png");
            stringBuffer.append("&styles=countryboundaries");
            stringBuffer.append("&transparent=true");
            return new URL(stringBuffer.toString());
        }
    }
}

