/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers;

import gov.nasa.worldwind.Cacheable;
import gov.nasa.worldwind.DrawContext;
import gov.nasa.worldwind.HTTPRetriever;
import gov.nasa.worldwind.PlaceName;
import gov.nasa.worldwind.PlaceNameRenderer;
import gov.nasa.worldwind.PlaceNameService;
import gov.nasa.worldwind.PlaceNameServiceSet;
import gov.nasa.worldwind.RetrievalPostProcessor;
import gov.nasa.worldwind.Retriever;
import gov.nasa.worldwind.URLRetriever;
import gov.nasa.worldwind.WWIO;
import gov.nasa.worldwind.WWIcon;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.Point;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.AbstractLayer;
import java.awt.Color;
import java.awt.Font;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlaceNameLayer
extends AbstractLayer {
    private final PlaceNameServiceSet placeNameServiceSet;
    private final List<Tile[]> tiles = new ArrayList<Tile[]>();
    private final PlaceNameRenderer placeNameRenderer = new PlaceNameRenderer();
    private static final int MAX_REQUESTS = 64;
    private final Queue<Tile> downloadQueue = new LinkedBlockingQueue<Tile>(64);
    private final Queue<Tile> readQueue = new LinkedBlockingQueue<Tile>(64);

    public PlaceNameLayer(PlaceNameServiceSet placeNameServiceSet) {
        if (placeNameServiceSet == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.PlaceNameServiceSetIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.placeNameServiceSet = placeNameServiceSet.deepCopy();
        for (int i = 0; i < this.placeNameServiceSet.getServiceCount(); ++i) {
            this.tiles.add(i, this.buildTiles(this.placeNameServiceSet.getService(i)));
        }
    }

    public final PlaceNameServiceSet getPlaceNameServiceSet() {
        return this.placeNameServiceSet;
    }

    private Tile[] buildTiles(PlaceNameService placeNameService) {
        Sector sector = placeNameService.getSector();
        Angle angle = placeNameService.getTileDelta().getLatitude();
        Angle angle2 = placeNameService.getTileDelta().getLongitude();
        int n = Tile.computeRow(angle, sector.getMinLatitude());
        int n2 = Tile.computeColumn(angle2, sector.getMinLongitude());
        int n3 = Tile.computeRow(angle, sector.getMaxLatitude().subtract(angle));
        int n4 = Tile.computeColumn(angle2, sector.getMaxLongitude().subtract(angle2));
        int n5 = n3 - n + 1;
        int n6 = n4 - n2 + 1;
        Tile[] tileArray = new Tile[n5 * n6];
        Angle angle3 = Tile.computeRowLatitude(n, angle);
        for (int i = n; i <= n3; ++i) {
            Angle angle4 = angle3.add(angle);
            Angle angle5 = Tile.computeColumnLongitude(n2, angle2);
            for (int j = n2; j <= n4; ++j) {
                Angle angle6 = angle5.add(angle2);
                tileArray[j + i * n6] = new Tile(placeNameService, new Sector(angle3, angle4, angle5, angle6), i, j);
                angle5 = angle6;
            }
            angle3 = angle4;
        }
        return tileArray;
    }

    @Override
    protected void doRender(DrawContext drawContext) {
        boolean bl = drawContext.getView().getAltitude() < drawContext.getVerticalExaggeration() * drawContext.getGlobe().getMaxElevation();
        int n = this.placeNameServiceSet.getServiceCount();
        for (int i = 0; i < n; ++i) {
            Tile[] tileArray;
            PlaceNameService placeNameService = this.placeNameServiceSet.getService(i);
            if (!PlaceNameLayer.isServiceVisible(drawContext, placeNameService)) continue;
            double d = placeNameService.getMinDisplayDistance();
            double d2 = placeNameService.getMaxDisplayDistance();
            double d3 = d * d;
            double d4 = d2 * d2;
            for (Tile tile : tileArray = this.tiles.get(i)) {
                try {
                    this.drawOrRequestTile(drawContext, tile, d3, d4, bl);
                }
                catch (Exception exception) {
                    String string = WorldWind.retrieveErrMsg("layers.PlaceNameLayer.ExceptionRenderingTile");
                    WorldWind.logger().log(Level.FINE, string, exception);
                }
            }
        }
        this.sendRequests();
    }

    private void drawOrRequestTile(DrawContext drawContext, Tile tile, double d, double d2, boolean bl) {
        if (!PlaceNameLayer.isTileVisible(drawContext, tile, d, d2)) {
            return;
        }
        Object object = WorldWind.memoryCache().getObject(tile);
        if (object == null) {
            this.requestTile(this.readQueue, tile);
            return;
        }
        if (!(object instanceof PlaceNameChunk)) {
            return;
        }
        PlaceNameChunk placeNameChunk = (PlaceNameChunk)object;
        Iterator<PlaceName> iterator = placeNameChunk.createRenderIterator(drawContext);
        this.placeNameRenderer.render(drawContext, iterator, bl);
    }

    private static boolean isServiceVisible(DrawContext drawContext, PlaceNameService placeNameService) {
        if (!placeNameService.isEnabled()) {
            return false;
        }
        if (drawContext.getVisibleSector() != null && !placeNameService.getSector().intersects(drawContext.getVisibleSector())) {
            return false;
        }
        return placeNameService.getExtent(drawContext).intersects(drawContext.getView().getFrustumInModelCoordinates());
    }

    private static boolean isTileVisible(DrawContext drawContext, Tile tile, double d, double d2) {
        if (!tile.getSector().intersects(drawContext.getVisibleSector())) {
            return false;
        }
        Position position = drawContext.getView().getPosition();
        Angle angle = PlaceNameLayer.clampAngle(position.getLatitude(), tile.getSector().getMinLatitude(), tile.getSector().getMaxLatitude());
        Angle angle2 = PlaceNameLayer.clampAngle(position.getLongitude(), tile.getSector().getMinLongitude(), tile.getSector().getMaxLongitude());
        Point point = drawContext.getGlobe().computePointFromPosition(angle, angle2, 0.0);
        double d3 = drawContext.getView().getEyePoint().distanceToSquared(point);
        return !(d > d3) && !(d2 < d3);
    }

    private static boolean isNameVisible(DrawContext drawContext, PlaceNameService placeNameService, Position position) {
        double d = drawContext.getVerticalExaggeration() * position.getElevation();
        Point point = drawContext.getGlobe().computePointFromPosition(position.getLatitude(), position.getLongitude(), d);
        Point point2 = drawContext.getView().getEyePoint();
        double d2 = point2.distanceTo(point);
        return d2 >= placeNameService.getMinDisplayDistance() && d2 <= placeNameService.getMaxDisplayDistance();
    }

    private static Angle clampAngle(Angle angle, Angle angle2, Angle angle3) {
        return angle.compareTo(angle2) < 0 ? angle2 : (angle.compareTo(angle3) > 0 ? angle3 : angle);
    }

    private boolean loadTile(Tile tile, URL uRL) {
        PlaceNameChunk placeNameChunk = PlaceNameLayer.readTile(tile, uRL);
        if (placeNameChunk == null) {
            return false;
        }
        WorldWind.memoryCache().add(tile, placeNameChunk);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PlaceNameChunk readTile(Tile tile, URL uRL) {
        String string;
        InputStream inputStream = null;
        try {
            String string2 = uRL.getFile();
            string2 = string2.replaceAll("%20", " ");
            FileInputStream fileInputStream = new FileInputStream(string2);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            inputStream = new GZIPInputStream(bufferedInputStream);
            GMLPlaceNameSAXHandler gMLPlaceNameSAXHandler = new GMLPlaceNameSAXHandler();
            SAXParserFactory.newInstance().newSAXParser().parse(inputStream, (DefaultHandler)gMLPlaceNameSAXHandler);
            PlaceNameChunk placeNameChunk = gMLPlaceNameSAXHandler.createPlaceNameChunk(tile.getPlaceNameService());
            return placeNameChunk;
        }
        catch (Exception exception) {
            string = WorldWind.retrieveErrMsg("layers.PlaceNameLayer.ExceptionAttemptingToReadFile");
            WorldWind.logger().log(Level.FINE, string, exception);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                string = WorldWind.retrieveErrMsg("layers.PlaceNameLayer.ExceptionAttemptingToReadFile");
                WorldWind.logger().log(Level.FINE, string, iOException);
            }
        }
        return null;
    }

    private void requestTile(Queue<Tile> queue, Tile tile) {
        if (tile.getPlaceNameService().isResourceAbsent(tile.getPlaceNameService().getTileNumber(tile.row, tile.column))) {
            return;
        }
        if (!queue.contains(tile)) {
            queue.offer(tile);
        }
    }

    private void sendRequests() {
        Tile tile;
        while (!WorldWind.threadedTaskService().isFull() && (tile = this.readQueue.poll()) != null) {
            WorldWind.threadedTaskService().addTask(new RequestTask(this, tile));
        }
        while (!WorldWind.retrievalService().isFull() && (tile = this.downloadQueue.poll()) != null) {
            URL uRL;
            try {
                uRL = tile.getRequestURL();
            }
            catch (MalformedURLException malformedURLException) {
                String string = WorldWind.retrieveErrMsg("layers.PlaceNameLayer.ExceptionAttemptingToDownloadFile");
                WorldWind.logger().log(Level.FINE, string + tile, malformedURLException);
                return;
            }
            WorldWind.retrievalService().runRetriever(new HTTPRetriever(uRL, new DownloadPostProcessor(this, tile)));
        }
    }

    private static class GMLPlaceNameSAXHandler
    extends DefaultHandler {
        static final String GML_FEATURE_MEMBER = "gml:featureMember";
        static final String TOPP_FULL_NAME_ND = "topp:full_name_nd";
        static final String TOPP_LATITUDE = "topp:latitude";
        static final String TOPP_LONGITUDE = "topp:longitude";
        final LinkedList<String> qNameStack = new LinkedList();
        boolean inBeginEndPair = false;
        StringBuilder latBuffer = new StringBuilder();
        StringBuilder lonBuffer = new StringBuilder();
        StringBuilder textArray = new StringBuilder();
        int[] textIndexArray = new int[16];
        double[] latlonArray = new double[16];
        int numEntries = 0;

        GMLPlaceNameSAXHandler() {
        }

        PlaceNameChunk createPlaceNameChunk(PlaceNameService placeNameService) {
            return new PlaceNameChunk(placeNameService, this.textArray, this.textIndexArray, this.latlonArray, this.numEntries);
        }

        void beginEntry() {
            int n = this.textArray.length();
            this.textIndexArray = this.append(this.textIndexArray, this.numEntries, n);
            this.inBeginEndPair = true;
        }

        void endEntry() {
            double d = this.parseDouble(this.latBuffer);
            double d2 = this.parseDouble(this.lonBuffer);
            int n = 2 * this.numEntries;
            this.latlonArray = this.append(this.latlonArray, n, d);
            this.latlonArray = this.append(this.latlonArray, ++n, d2);
            this.latBuffer.delete(0, this.latBuffer.length());
            this.lonBuffer.delete(0, this.lonBuffer.length());
            this.inBeginEndPair = false;
            ++this.numEntries;
        }

        double parseDouble(StringBuilder stringBuilder) {
            double d = 0.0;
            try {
                d = Double.parseDouble(stringBuilder.toString());
            }
            catch (NumberFormatException numberFormatException) {
                String string = WorldWind.retrieveErrMsg("layers.PlaceNameLayer.ExceptionAttemptingToReadFile");
                WorldWind.logger().log(Level.FINE, string, numberFormatException);
            }
            return d;
        }

        int[] append(int[] nArray, int n, int n2) {
            if (n >= nArray.length) {
                nArray = this.resizeArray(nArray);
            }
            nArray[n] = n2;
            return nArray;
        }

        int[] resizeArray(int[] nArray) {
            int n = 2 * nArray.length;
            int[] nArray2 = new int[n];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            return nArray2;
        }

        double[] append(double[] dArray, int n, double d) {
            if (n >= dArray.length) {
                dArray = this.resizeArray(dArray);
            }
            dArray[n] = d;
            return dArray;
        }

        double[] resizeArray(double[] dArray) {
            int n = 2 * dArray.length;
            double[] dArray2 = new double[n];
            System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
            return dArray2;
        }

        public void characters(char[] cArray, int n, int n2) {
            if (!this.inBeginEndPair) {
                return;
            }
            String string = this.qNameStack.getFirst();
            StringBuilder stringBuilder = null;
            if (TOPP_LATITUDE == string) {
                stringBuilder = this.latBuffer;
            } else if (TOPP_LONGITUDE == string) {
                stringBuilder = this.lonBuffer;
            } else if (TOPP_FULL_NAME_ND == string) {
                stringBuilder = this.textArray;
            }
            if (stringBuilder != null) {
                stringBuilder.append(cArray, n, n2);
            }
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            String string4 = string3.intern();
            if (GML_FEATURE_MEMBER == string4) {
                this.beginEntry();
            }
            this.qNameStack.addFirst(string3);
        }

        public void endElement(String string, String string2, String string3) {
            String string4 = string3.intern();
            if (GML_FEATURE_MEMBER == string4) {
                this.endEntry();
            }
            this.qNameStack.removeFirst();
        }
    }

    private static class DownloadPostProcessor
    implements RetrievalPostProcessor {
        final PlaceNameLayer layer;
        final Tile tile;

        private DownloadPostProcessor(PlaceNameLayer placeNameLayer, Tile tile) {
            this.layer = placeNameLayer;
            this.tile = tile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ByteBuffer run(Retriever retriever) {
            if (retriever == null) {
                String string = WorldWind.retrieveErrMsg("nullValue.RetrieverIsNull");
                WorldWind.logger().log(Level.FINE, string);
                throw new IllegalArgumentException(string);
            }
            if (!retriever.getState().equals("gov.nasa.worldwind.RetrieverStatusSuccessful")) {
                return null;
            }
            if (!(retriever instanceof URLRetriever)) {
                return null;
            }
            try {
                URLRetriever uRLRetriever;
                if (retriever instanceof HTTPRetriever && ((HTTPRetriever)(uRLRetriever = (HTTPRetriever)retriever)).getResponseCode() == 204) {
                    this.tile.getPlaceNameService().markResourceAbsent(this.tile.getPlaceNameService().getTileNumber(this.tile.row, this.tile.column));
                    return null;
                }
                uRLRetriever = (URLRetriever)retriever;
                ByteBuffer byteBuffer = uRLRetriever.getBuffer();
                Tile tile = this.tile;
                synchronized (tile) {
                    File file = WorldWind.dataFileCache().newFile(this.tile.getFileCachePath());
                    if (file == null) {
                        String string = WorldWind.retrieveErrMsg("generic.CantCreateCacheFile") + this.tile.getFileCachePath();
                        WorldWind.logger().log(Level.FINE, string);
                        return null;
                    }
                    if (file.exists()) {
                        return byteBuffer;
                    }
                    if (byteBuffer != null) {
                        WWIO.saveBuffer(byteBuffer, file);
                        this.layer.firePropertyChange("gov.nasa.worldwind.avkey.LayerObject", null, this);
                        return byteBuffer;
                    }
                }
            }
            catch (IOException iOException) {
                String string = WorldWind.retrieveErrMsg("layers.PlaceNameLayer.ExceptionSavingRetrievedFile");
                WorldWind.logger().log(Level.FINE, string + this.tile.getFileCachePath(), iOException);
            }
            return null;
        }
    }

    private static class RequestTask
    implements Runnable {
        final PlaceNameLayer layer;
        final Tile tile;

        RequestTask(PlaceNameLayer placeNameLayer, Tile tile) {
            this.layer = placeNameLayer;
            this.tile = tile;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            RequestTask requestTask = (RequestTask)object;
            return !(this.tile == null ? requestTask.tile != null : !this.tile.equals(requestTask.tile));
        }

        public int hashCode() {
            return this.tile != null ? this.tile.hashCode() : 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Tile tile = this.tile;
            synchronized (tile) {
                if (WorldWind.memoryCache().getObject(this.tile) != null) {
                    return;
                }
                URL uRL = WorldWind.dataFileCache().findFile(this.tile.getFileCachePath(), false);
                if (uRL != null) {
                    if (this.layer.loadTile(this.tile, uRL)) {
                        this.tile.getPlaceNameService().unmarkResourceAbsent(this.tile.getPlaceNameService().getTileNumber(this.tile.row, this.tile.column));
                        this.layer.firePropertyChange("gov.nasa.worldwind.avkey.LayerObject", null, this);
                    } else {
                        WorldWind.dataFileCache().removeFile(uRL);
                        this.tile.getPlaceNameService().markResourceAbsent(this.tile.getPlaceNameService().getTileNumber(this.tile.row, this.tile.column));
                        String string = WorldWind.retrieveErrMsg("generic.DeletedCorruptDataFile") + uRL;
                        WorldWind.logger().log(Level.FINE, string);
                    }
                    return;
                }
            }
            this.layer.requestTile(this.layer.downloadQueue, this.tile);
        }

        public String toString() {
            return this.tile.toString();
        }
    }

    private static class PlaceNameImpl
    implements PlaceName {
        String text;
        Position position;
        Font font;
        Color color;
        boolean visible;

        PlaceNameImpl() {
        }

        public String getText() {
            return this.text;
        }

        public void setText(String string) {
            throw new UnsupportedOperationException();
        }

        public Position getPosition() {
            return this.position;
        }

        public void setPosition(Position position) {
            throw new UnsupportedOperationException();
        }

        public Font getFont() {
            return this.font;
        }

        public void setFont(Font font) {
            throw new UnsupportedOperationException();
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            throw new UnsupportedOperationException();
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean bl) {
            throw new UnsupportedOperationException();
        }

        public WWIcon getIcon() {
            return null;
        }

        public void setIcon(WWIcon wWIcon) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PlaceNameChunk
    implements Cacheable {
        final PlaceNameService placeNameService;
        final StringBuilder textArray;
        final int[] textIndexArray;
        final double[] latlonArray;
        final int numEntries;
        final long estimatedMemorySize;

        PlaceNameChunk(PlaceNameService placeNameService, StringBuilder stringBuilder, int[] nArray, double[] dArray, int n) {
            this.placeNameService = placeNameService;
            this.textArray = stringBuilder;
            this.textIndexArray = nArray;
            this.latlonArray = dArray;
            this.numEntries = n;
            this.estimatedMemorySize = this.computeEstimatedMemorySize();
        }

        long computeEstimatedMemorySize() {
            long l = 0L;
            l += (long)(2 * this.textArray.capacity());
            l += (long)(4 * this.textIndexArray.length);
            return l += (long)(8 * this.latlonArray.length);
        }

        Position getPosition(int n) {
            int n2 = 2 * n;
            return Position.fromDegrees(this.latlonArray[n2], this.latlonArray[n2 + 1], 0.0);
        }

        PlaceNameService getPlaceNameService() {
            return this.placeNameService;
        }

        String getText(int n) {
            int n2 = this.textIndexArray[n];
            int n3 = n + 1 < this.numEntries ? this.textIndexArray[n + 1] : this.textArray.length();
            return this.textArray.substring(n2, n3);
        }

        @Override
        public long getSizeInBytes() {
            return this.estimatedMemorySize;
        }

        Iterator<PlaceName> createRenderIterator(final DrawContext drawContext) {
            return new Iterator<PlaceName>(){
                PlaceNameImpl placeNameProxy = new PlaceNameImpl();
                int index = -1;

                @Override
                public boolean hasNext() {
                    return this.index < PlaceNameChunk.this.numEntries - 1;
                }

                @Override
                public PlaceName next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.updateProxy(this.placeNameProxy, ++this.index);
                    return this.placeNameProxy;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                void updateProxy(PlaceNameImpl placeNameImpl, int n) {
                    placeNameImpl.text = PlaceNameChunk.this.getText(n);
                    placeNameImpl.position = PlaceNameChunk.this.getPosition(n);
                    placeNameImpl.font = PlaceNameChunk.this.placeNameService.getFont();
                    placeNameImpl.color = PlaceNameChunk.this.placeNameService.getColor();
                    placeNameImpl.visible = PlaceNameLayer.isNameVisible(drawContext, PlaceNameChunk.this.placeNameService, placeNameImpl.position);
                }
            };
        }
    }

    private static class Tile {
        final PlaceNameService placeNameService;
        final Sector sector;
        final int row;
        final int column;
        final int hash;
        String fileCachePath = null;
        Extent extent = null;
        double extentVerticalExaggeration = Double.MIN_VALUE;

        static int computeRow(Angle angle, Angle angle2) {
            if (angle == null || angle2 == null) {
                String string = WorldWind.retrieveErrMsg("nullValue.AngleIsNull");
                WorldWind.logger().log(Level.FINE, string);
                throw new IllegalArgumentException(string);
            }
            return (int)((angle2.getDegrees() + 90.0) / angle.getDegrees());
        }

        static int computeColumn(Angle angle, Angle angle2) {
            if (angle == null || angle2 == null) {
                String string = WorldWind.retrieveErrMsg("nullValue.AngleIsNull");
                WorldWind.logger().log(Level.FINE, string);
                throw new IllegalArgumentException(string);
            }
            return (int)((angle2.getDegrees() + 180.0) / angle.getDegrees());
        }

        static Angle computeRowLatitude(int n, Angle angle) {
            if (angle == null) {
                String string = WorldWind.retrieveErrMsg("nullValue.AngleIsNull");
                WorldWind.logger().log(Level.FINE, string);
                throw new IllegalArgumentException(string);
            }
            return Angle.fromDegrees(-90.0 + angle.getDegrees() * (double)n);
        }

        static Angle computeColumnLongitude(int n, Angle angle) {
            if (angle == null) {
                String string = WorldWind.retrieveErrMsg("nullValue.AngleIsNull");
                WorldWind.logger().log(Level.FINE, string);
                throw new IllegalArgumentException(string);
            }
            return Angle.fromDegrees(-180.0 + angle.getDegrees() * (double)n);
        }

        Tile(PlaceNameService placeNameService, Sector sector, int n, int n2) {
            this.placeNameService = placeNameService;
            this.sector = sector;
            this.row = n;
            this.column = n2;
            this.hash = this.computeHash();
        }

        int computeHash() {
            return this.getFileCachePath() != null ? this.getFileCachePath().hashCode() : 0;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Tile tile = (Tile)object;
            return this.getFileCachePath() != null ? !this.getFileCachePath().equals(tile.getFileCachePath()) : tile.getFileCachePath() != null;
        }

        Extent getExtent(DrawContext drawContext) {
            if (drawContext == null) {
                String string = WorldWind.retrieveErrMsg("nullValue.DrawContextIsNull");
                WorldWind.logger().log(Level.FINE, string);
                throw new IllegalArgumentException(string);
            }
            if (this.extent == null || this.extentVerticalExaggeration != drawContext.getVerticalExaggeration()) {
                this.extentVerticalExaggeration = drawContext.getVerticalExaggeration();
                this.extent = Sector.computeBoundingCylinder(drawContext.getGlobe(), this.extentVerticalExaggeration, this.sector);
            }
            return this.extent;
        }

        String getFileCachePath() {
            if (this.fileCachePath == null) {
                this.fileCachePath = this.placeNameService.createFileCachePathFromTile(this.row, this.column);
            }
            return this.fileCachePath;
        }

        PlaceNameService getPlaceNameService() {
            return this.placeNameService;
        }

        URL getRequestURL() throws MalformedURLException {
            return this.placeNameService.createServiceURLFromSector(this.sector);
        }

        Sector getSector() {
            return this.sector;
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

