/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers;

import gov.nasa.worldwind.Disposable;
import gov.nasa.worldwind.DrawContext;
import gov.nasa.worldwind.Layer;
import gov.nasa.worldwind.Locatable;
import gov.nasa.worldwind.PickSupport;
import gov.nasa.worldwind.Renderable;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.layers.AbstractLayer;
import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderableLayer
extends AbstractLayer {
    private Collection<Renderable> renderables = new ArrayList<Renderable>();
    private final PickSupport pickSupport = new PickSupport();
    private final Layer delegateOwner;

    public RenderableLayer() {
        this.delegateOwner = null;
    }

    public RenderableLayer(Layer layer) {
        this.delegateOwner = layer;
    }

    public void setRenderables(Iterable<Renderable> iterable) {
        this.renderables = new ArrayList<Renderable>();
        if (iterable == null) {
            return;
        }
        for (Renderable renderable : iterable) {
            this.renderables.add(renderable);
        }
    }

    public void addRenderable(Renderable renderable) {
        if (renderable == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.Shape");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.renderables.add(renderable);
    }

    public void removeRenderable(Renderable renderable) {
        if (renderable == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.Shape");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.renderables.remove(renderable);
    }

    public Collection<Renderable> getRenderables() {
        return this.renderables;
    }

    @Override
    public void dispose() {
        for (Renderable renderable : this.renderables) {
            if (!(renderable instanceof Disposable)) continue;
            ((Disposable)((Object)renderable)).dispose();
        }
    }

    @Override
    protected void doPick(DrawContext drawContext, Point point) {
        this.pickSupport.clearPickList();
        this.pickSupport.beginPicking(drawContext);
        for (Renderable renderable : this.renderables) {
            float[] fArray = new float[4];
            drawContext.getGL().glGetFloatv(2816, fArray, 0);
            Color color = drawContext.getUniquePickColor();
            drawContext.getGL().glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
            renderable.render(drawContext);
            drawContext.getGL().glColor4fv(fArray, 0);
            if (renderable instanceof Locatable) {
                this.pickSupport.addPickableObject(color.getRGB(), renderable, ((Locatable)((Object)renderable)).getPosition(), false);
                continue;
            }
            this.pickSupport.addPickableObject(color.getRGB(), renderable);
        }
        this.pickSupport.resolvePick(drawContext, point, this.delegateOwner != null ? this.delegateOwner : this);
        this.pickSupport.endPicking(drawContext);
    }

    @Override
    protected void doRender(DrawContext drawContext) {
        for (Renderable renderable : this.renderables) {
            renderable.render(drawContext);
        }
    }

    public Layer getDelegateOwner() {
        return this.delegateOwner;
    }

    @Override
    public String toString() {
        return WorldWind.retrieveErrMsg("layers.RenderableLayer.Name");
    }
}

