/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers;

import com.sun.opengl.util.j2d.TextRenderer;
import com.sun.opengl.util.texture.TextureData;
import com.sun.opengl.util.texture.TextureIO;
import gov.nasa.worldwind.DDSConverter;
import gov.nasa.worldwind.DrawContext;
import gov.nasa.worldwind.HTTPRetriever;
import gov.nasa.worldwind.Level;
import gov.nasa.worldwind.LevelSet;
import gov.nasa.worldwind.RetrievalPostProcessor;
import gov.nasa.worldwind.Retriever;
import gov.nasa.worldwind.Tile;
import gov.nasa.worldwind.URLRetriever;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WWIO;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Cylinder;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Point;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.AbstractLayer;
import gov.nasa.worldwind.layers.TextureTile;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.PriorityBlockingQueue;
import javax.imageio.ImageIO;
import javax.media.opengl.GL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TiledImageLayer
extends AbstractLayer {
    private static final LevelComparer levelComparer = new LevelComparer();
    private final LevelSet levels;
    private ArrayList<TextureTile> topLevels;
    private final Object fileLock = new Object();
    private boolean forceLevelZeroLoads = false;
    private boolean retainLevelZeroTiles = false;
    private boolean showImageTileOutlines = false;
    private boolean drawTileBoundaries = false;
    private boolean drawWireframe = false;
    private boolean useTransparentTextures = false;
    private boolean drawTileIDs = false;
    private boolean drawBoundingVolumes = false;
    private TextRenderer textRenderer = null;
    private ArrayList<TextureTile> currentTiles = new ArrayList();
    private TextureTile currentResourceTile;
    private Point referencePoint;
    private PriorityBlockingQueue<RequestTask> requestQ = new PriorityBlockingQueue(200);
    private static final String[] formats = new String[]{"jpg", "jpeg", "png", "tiff"};
    private static final String[] suffixes = new String[]{".jpg", ".jpg", ".png", ".tiff"};

    public TiledImageLayer(LevelSet levelSet) {
        if (levelSet == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.LevelSetIsNull");
            WorldWind.logger().log(java.util.logging.Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.levels = new LevelSet(levelSet);
        this.createTopLevelTiles();
        if (this.forceLevelZeroLoads) {
            this.loadAllTopLevelTextures();
        }
        this.setPickEnabled(false);
    }

    @Override
    public void dispose() {
        if (!this.retainLevelZeroTiles) {
            return;
        }
        for (TextureTile textureTile : this.topLevels) {
            textureTile.dispose();
        }
    }

    public boolean isUseTransparentTextures() {
        return this.useTransparentTextures;
    }

    public void setUseTransparentTextures(boolean bl) {
        this.useTransparentTextures = bl;
    }

    public boolean isForceLevelZeroLoads() {
        return this.forceLevelZeroLoads;
    }

    public void setForceLevelZeroLoads(boolean bl) {
        this.forceLevelZeroLoads = bl;
        if (this.forceLevelZeroLoads) {
            this.loadAllTopLevelTextures();
        }
    }

    public boolean isRetainLevelZeroTiles() {
        return this.retainLevelZeroTiles;
    }

    public void setRetainLevelZeroTiles(boolean bl) {
        this.retainLevelZeroTiles = bl;
    }

    public boolean isDrawTileIDs() {
        return this.drawTileIDs;
    }

    public void setDrawTileIDs(boolean bl) {
        this.drawTileIDs = bl;
    }

    public boolean isDrawTileBoundaries() {
        return this.drawTileBoundaries;
    }

    public void setDrawTileBoundaries(boolean bl) {
        this.drawTileBoundaries = bl;
    }

    public boolean isDrawWireframe() {
        return this.drawWireframe;
    }

    public void setDrawWireframe(boolean bl) {
        this.drawWireframe = bl;
    }

    public boolean isShowImageTileOutlines() {
        return this.showImageTileOutlines;
    }

    public void setShowImageTileOutlines(boolean bl) {
        this.showImageTileOutlines = bl;
    }

    public boolean isDrawBoundingVolumes() {
        return this.drawBoundingVolumes;
    }

    public void setDrawBoundingVolumes(boolean bl) {
        this.drawBoundingVolumes = bl;
    }

    private void createTopLevelTiles() {
        Sector sector = this.levels.getSector();
        Angle angle = this.levels.getLevelZeroTileDelta().getLatitude();
        Angle angle2 = this.levels.getLevelZeroTileDelta().getLongitude();
        Level level = this.levels.getFirstLevel();
        int n = Tile.computeRow(level.getTileDelta().getLatitude(), sector.getMinLatitude());
        int n2 = Tile.computeColumn(level.getTileDelta().getLongitude(), sector.getMinLongitude());
        int n3 = Tile.computeRow(level.getTileDelta().getLatitude(), sector.getMaxLatitude());
        int n4 = Tile.computeColumn(level.getTileDelta().getLongitude(), sector.getMaxLongitude());
        int n5 = n3 - n + 1;
        int n6 = n4 - n2 + 1;
        this.topLevels = new ArrayList(n5 * n6);
        Angle angle3 = Tile.computeRowLatitude(n, angle);
        for (int i = n; i <= n3; ++i) {
            Angle angle4 = angle3.add(angle);
            Angle angle5 = Tile.computeColumnLongitude(n2, angle2);
            for (int j = n2; j <= n4; ++j) {
                Angle angle6 = angle5.add(angle2);
                this.topLevels.add(new TextureTile(new Sector(angle3, angle4, angle5, angle6), level, i, j));
                angle5 = angle6;
            }
            angle3 = angle4;
        }
    }

    private void loadAllTopLevelTextures() {
        for (TextureTile textureTile : this.topLevels) {
            if (textureTile.holdsTexture()) continue;
            this.forceTextureLoad(textureTile);
        }
    }

    private void assembleTiles(DrawContext drawContext) {
        this.currentTiles.clear();
        for (TextureTile textureTile : this.topLevels) {
            if (!this.isTileVisible(drawContext, textureTile)) continue;
            this.currentResourceTile = null;
            this.addTileOrDescendants(drawContext, textureTile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTileOrDescendants(DrawContext drawContext, TextureTile textureTile) {
        if (this.meetsRenderCriteria(drawContext, textureTile)) {
            this.addTile(drawContext, textureTile);
            return;
        }
        TextureTile textureTile2 = null;
        try {
            TextureTile[] textureTileArray;
            if (textureTile.holdsTexture() || textureTile.getLevelNumber() == 0) {
                textureTile2 = this.currentResourceTile;
                this.currentResourceTile = textureTile;
            }
            if (this.levels.isFinalLevel(textureTile.getLevelNumber()) && !this.isTextureInMemory(textureTile)) {
                this.requestTexture(drawContext, textureTile);
            }
            for (TextureTile textureTile3 : textureTileArray = textureTile.createSubTiles(this.levels.getLevel(textureTile.getLevelNumber() + 1))) {
                if (!this.isTileVisible(drawContext, textureTile3)) continue;
                this.addTileOrDescendants(drawContext, textureTile3);
            }
        }
        finally {
            if (textureTile2 != null) {
                this.currentResourceTile = textureTile2;
            }
        }
    }

    private void addTile(DrawContext drawContext, TextureTile textureTile) {
        textureTile.setFallbackTile(null);
        if (textureTile.holdsTexture()) {
            this.addTileToCurrent(textureTile);
            return;
        }
        if (textureTile.getLevelNumber() == 0 && this.forceLevelZeroLoads) {
            this.forceTextureLoad(textureTile);
            if (textureTile.holdsTexture()) {
                this.addTileToCurrent(textureTile);
                return;
            }
        }
        if (textureTile.getLevelNumber() < this.levels.getNumLevels() && !this.levels.isResourceAbsent(textureTile)) {
            this.requestTexture(drawContext, textureTile);
        }
        if (this.currentResourceTile != null) {
            if (this.currentResourceTile.getLevelNumber() == 0 && this.forceLevelZeroLoads && !this.currentResourceTile.holdsTexture()) {
                this.forceTextureLoad(this.currentResourceTile);
            }
            if (this.currentResourceTile.holdsTexture()) {
                textureTile.setFallbackTile(this.currentResourceTile);
                this.addTileToCurrent(textureTile);
            }
        }
    }

    private void addTileToCurrent(TextureTile textureTile) {
        this.currentTiles.add(textureTile);
    }

    private boolean isTileVisible(DrawContext drawContext, TextureTile textureTile) {
        return textureTile.getExtent(drawContext).intersects(drawContext.getView().getFrustumInModelCoordinates()) && (drawContext.getVisibleSector() == null || drawContext.getVisibleSector().intersects(textureTile.getSector()));
    }

    private boolean meetsRenderCriteria(DrawContext drawContext, TextureTile textureTile) {
        return this.levels.isFinalLevel(textureTile.getLevelNumber()) || !TiledImageLayer.needToSplit(drawContext, textureTile.getSector(), 20);
    }

    private static boolean needToSplit(DrawContext drawContext, Sector sector, int n) {
        double d;
        Point[] pointArray = sector.computeCornerPoints(drawContext.getGlobe());
        Point point = sector.computeCenterPoint(drawContext.getGlobe());
        View view = drawContext.getView();
        double d2 = view.getEyePoint().distanceTo(pointArray[0]);
        double d3 = view.getEyePoint().distanceTo(pointArray[1]);
        double d4 = view.getEyePoint().distanceTo(pointArray[2]);
        double d5 = view.getEyePoint().distanceTo(pointArray[3]);
        double d6 = view.getEyePoint().distanceTo(point);
        double d7 = d2;
        if (d3 < d7) {
            d7 = d3;
        }
        if (d4 < d7) {
            d7 = d4;
        }
        if (d5 < d7) {
            d7 = d5;
        }
        if (d6 < d7) {
            d7 = d6;
        }
        return !(Math.log10(d = Math.PI * sector.getDeltaLatRadians() * drawContext.getGlobe().getRadius() / (double)n) <= Math.log10(d7) - 1.0);
    }

    @Override
    protected final void doRender(DrawContext drawContext) {
        if (drawContext.getSurfaceGeometry() == null || drawContext.getSurfaceGeometry().size() < 1) {
            return;
        }
        drawContext.getSurfaceTileRenderer().setShowImageTileOutlines(this.showImageTileOutlines);
        this.draw(drawContext);
    }

    private void draw(DrawContext drawContext) {
        TextureTile.disposeTextures();
        if (!this.isEnabled()) {
            return;
        }
        if (!this.isLayerActive(drawContext)) {
            return;
        }
        if (!this.isLayerInView(drawContext)) {
            return;
        }
        this.referencePoint = this.computeReferencePoint(drawContext);
        this.assembleTiles(drawContext);
        if (this.currentTiles.size() >= 1) {
            TextureTile[] textureTileArray = new TextureTile[this.currentTiles.size()];
            textureTileArray = this.currentTiles.toArray(textureTileArray);
            Arrays.sort(textureTileArray, levelComparer);
            GL gL = drawContext.getGL();
            gL.glPushAttrib(16392);
            if (this.isUseTransparentTextures()) {
                gL.glEnable(3042);
                gL.glBlendFunc(770, 771);
            }
            gL.glPolygonMode(1028, 6914);
            gL.glEnable(2884);
            gL.glCullFace(1029);
            drawContext.getSurfaceTileRenderer().renderTiles(drawContext, this.currentTiles);
            gL.glPopAttrib();
            if (this.drawTileIDs) {
                this.drawTileIDs(drawContext, this.currentTiles);
            }
            if (this.drawBoundingVolumes) {
                this.drawBoundingVolumes(drawContext, this.currentTiles);
            }
            this.currentTiles.clear();
        }
        this.sendRequests();
        this.requestQ.clear();
    }

    private void sendRequests() {
        RequestTask requestTask = this.requestQ.poll();
        while (requestTask != null) {
            if (!WorldWind.threadedTaskService().isFull()) {
                WorldWind.threadedTaskService().addTask(requestTask);
            }
            requestTask = this.requestQ.poll();
        }
    }

    @Override
    public boolean isLayerInView(DrawContext drawContext) {
        if (drawContext == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.DrawContextIsNull");
            WorldWind.logger().log(java.util.logging.Level.FINE, string);
            throw new IllegalStateException(string);
        }
        if (drawContext.getView() == null) {
            String string = WorldWind.retrieveErrMsg("layers.AbstractLayer.NoViewSpecifiedInDrawingContext");
            WorldWind.logger().log(java.util.logging.Level.FINE, string);
            throw new IllegalStateException(string);
        }
        if (drawContext.getVisibleSector() != null && !this.levels.getSector().intersects(drawContext.getVisibleSector())) {
            return false;
        }
        Cylinder cylinder = Sector.computeBoundingCylinder(drawContext.getGlobe(), drawContext.getVerticalExaggeration(), this.levels.getSector());
        return cylinder.intersects(drawContext.getView().getFrustumInModelCoordinates());
    }

    private Point computeReferencePoint(DrawContext drawContext) {
        Rectangle rectangle = drawContext.getView().getViewport();
        int n = (int)((RectangularShape)rectangle).getWidth() / 2;
        for (int i = (int)(0.75 * ((RectangularShape)rectangle).getHeight()); i >= 0; --i) {
            Position position = drawContext.getView().computePositionFromScreenPoint(n, i);
            if (position == null) continue;
            return drawContext.getGlobe().computePointFromPosition(position.getLatitude(), position.getLongitude(), 0.0);
        }
        return null;
    }

    private void drawTileIDs(DrawContext drawContext, ArrayList<TextureTile> arrayList) {
        Rectangle rectangle = drawContext.getView().getViewport();
        if (this.textRenderer == null) {
            this.textRenderer = new TextRenderer(Font.decode("Arial-Plain-13"), true, true);
        }
        drawContext.getGL().glDisable(2929);
        drawContext.getGL().glDisable(3042);
        drawContext.getGL().glDisable(3553);
        this.textRenderer.setColor(Color.YELLOW);
        this.textRenderer.beginRendering(rectangle.width, rectangle.height);
        for (TextureTile textureTile : arrayList) {
            String string = textureTile.getLabel();
            if (textureTile.getFallbackTile() != null) {
                string = string + "/" + textureTile.getFallbackTile().getLabel();
            }
            LatLon latLon = textureTile.getSector().getCentroid();
            Point point = drawContext.getGlobe().computePointFromPosition(latLon.getLatitude(), latLon.getLongitude(), drawContext.getGlobe().getElevation(latLon.getLatitude(), latLon.getLongitude()));
            point = drawContext.getView().project(point);
            this.textRenderer.draw(string, (int)point.x(), (int)point.y());
        }
        this.textRenderer.endRendering();
    }

    private void drawBoundingVolumes(DrawContext drawContext, ArrayList<TextureTile> arrayList) {
        float[] fArray = new float[4];
        drawContext.getGL().glGetFloatv(2816, fArray, 0);
        drawContext.getGL().glColor3d(0.0, 1.0, 0.0);
        for (TextureTile textureTile : arrayList) {
            ((Cylinder)textureTile.getExtent(drawContext)).render(drawContext);
        }
        drawContext.getGL().glColor4fv(fArray, 0);
    }

    private void requestTexture(DrawContext drawContext, TextureTile textureTile) {
        Point point = textureTile.getCentroidPoint(drawContext.getGlobe());
        if (this.referencePoint != null) {
            textureTile.setPriority(point.distanceTo(this.referencePoint));
        }
        RequestTask requestTask = new RequestTask(textureTile, this);
        this.requestQ.add(requestTask);
    }

    private void forceTextureLoad(TextureTile textureTile) {
        URL uRL = WorldWind.dataFileCache().findFile(textureTile.getPath(), true);
        if (uRL != null && WWIO.isFileOutOfDate(uRL, textureTile.getLevel().getExpiryTime())) {
            WorldWind.dataFileCache().removeFile(uRL);
            String string = WorldWind.retrieveErrMsg("generic.DataFileExpired") + uRL;
            WorldWind.logger().log(java.util.logging.Level.FINER, string);
        } else if (uRL != null) {
            this.loadTexture(textureTile, uRL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadTexture(TextureTile textureTile, URL uRL) {
        TextureData textureData;
        Object object = this.fileLock;
        synchronized (object) {
            textureData = TiledImageLayer.readTexture(uRL);
        }
        if (textureData == null) {
            return false;
        }
        textureTile.setTextureData(textureData);
        if (textureTile.getLevelNumber() != 0 || !this.retainLevelZeroTiles) {
            this.addTileToCache(textureTile);
        }
        return true;
    }

    private static TextureData readTexture(URL uRL) {
        try {
            return TextureIO.newTextureData(uRL, false, null);
        }
        catch (Exception exception) {
            String string = WorldWind.retrieveErrMsg("layers.TextureLayer.ExceptionAttemptingToReadTextureFile");
            WorldWind.logger().log(java.util.logging.Level.FINE, string + uRL, exception);
            return null;
        }
    }

    private void addTileToCache(TextureTile textureTile) {
        WorldWind.memoryCache().add(textureTile.getTileKey(), textureTile);
    }

    private boolean isTextureInMemory(TextureTile textureTile) {
        return textureTile.getLevelNumber() == 0 && textureTile.holdsTexture() || WorldWind.memoryCache().getObject(textureTile.getTileKey()) != null;
    }

    private void downloadTexture(TextureTile textureTile) {
        URL uRL;
        if (WorldWind.retrievalService().isFull()) {
            return;
        }
        try {
            uRL = textureTile.getResourceURL();
        }
        catch (MalformedURLException malformedURLException) {
            String string = WorldWind.retrieveErrMsg("layers.TextureLayer.ExceptionCreatingTextureUrl");
            WorldWind.logger().log(java.util.logging.Level.FINE, string + textureTile, malformedURLException);
            return;
        }
        HTTPRetriever hTTPRetriever = new HTTPRetriever(uRL, new DownloadPostProcessor(textureTile, this));
        WorldWind.retrievalService().runRetriever(hTTPRetriever, textureTile.getPriority());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveBuffer(ByteBuffer byteBuffer, File file) throws IOException {
        Object object = this.fileLock;
        synchronized (object) {
            WWIO.saveBuffer(byteBuffer, file);
        }
    }

    public Color getColor(Angle angle, Angle angle2, int n) {
        Object object;
        Tile tile = null;
        Object object2 = this.topLevels.iterator();
        while (object2.hasNext() && (tile = this.getContainingTile((TextureTile)(object = object2.next()), angle, angle2, n)) == null) {
        }
        if (tile == null) {
            return null;
        }
        object2 = tile.getPath().substring(0, tile.getPath().lastIndexOf("."));
        object = (String)object2 + ".BufferedImage";
        BufferedImage bufferedImage = (BufferedImage)WorldWind.memoryCache().getObject(object);
        if (bufferedImage != null) {
            return this.resolveColor((TextureTile)tile, bufferedImage, angle, angle2);
        }
        bufferedImage = this.requestImage((TextureTile)tile, (String)object);
        if (bufferedImage != null) {
            return this.resolveColor((TextureTile)tile, bufferedImage, angle, angle2);
        }
        this.downloadImage((TextureTile)tile);
        bufferedImage = this.requestImage((TextureTile)tile, (String)object);
        if (bufferedImage != null) {
            return this.resolveColor((TextureTile)tile, bufferedImage, angle, angle2);
        }
        return null;
    }

    private BufferedImage requestImage(TextureTile textureTile, String string) {
        Object object;
        URL uRL = null;
        String string2 = textureTile.getPath().substring(0, textureTile.getPath().lastIndexOf("."));
        for (String string3 : suffixes) {
            String string4 = string2 + string3;
            uRL = WorldWind.dataFileCache().findFile(string4, false);
            if (uRL != null) break;
        }
        if (uRL == null) {
            return null;
        }
        if (WWIO.isFileOutOfDate(uRL, textureTile.getLevel().getExpiryTime())) {
            WorldWind.dataFileCache().removeFile(uRL);
            object = WorldWind.retrieveErrMsg("generic.DataFileExpired") + uRL;
            WorldWind.logger().log(java.util.logging.Level.FINER, (String)object);
        } else {
            try {
                object = ImageIO.read(new File(uRL.toURI()));
                if (object == null) {
                    return null;
                }
                WorldWind.memoryCache().add(string, object, ((BufferedImage)object).getRaster().getDataBuffer().getSize());
                this.levels.unmarkResourceAbsent(textureTile);
                return object;
            }
            catch (IOException iOException) {
                WorldWind.dataFileCache().removeFile(uRL);
                this.levels.markResourceAbsent(textureTile);
                String string5 = WorldWind.retrieveErrMsg("generic.DeletedCorruptDataFile") + uRL;
                WorldWind.logger().log(java.util.logging.Level.FINE, string5);
            }
            catch (URISyntaxException uRISyntaxException) {
                uRISyntaxException.printStackTrace();
            }
        }
        return null;
    }

    private void downloadImage(final TextureTile textureTile) {
        try {
            String string = textureTile.getResourceURL().toExternalForm().replace("dds", "");
            URL uRL = new URL(string);
            HTTPRetriever hTTPRetriever = new HTTPRetriever(uRL, new RetrievalPostProcessor(){

                public ByteBuffer run(Retriever retriever) {
                    if (!retriever.getState().equals("gov.nasa.worldwind.RetrieverStatusSuccessful")) {
                        return null;
                    }
                    HTTPRetriever hTTPRetriever = (HTTPRetriever)retriever;
                    if (hTTPRetriever.getResponseCode() == 204) {
                        TiledImageLayer.this.levels.markResourceAbsent(textureTile);
                        return null;
                    }
                    URLRetriever uRLRetriever = (URLRetriever)retriever;
                    ByteBuffer byteBuffer = uRLRetriever.getBuffer();
                    String string = null;
                    for (int i = 0; i < formats.length; ++i) {
                        if (!hTTPRetriever.getContentType().toLowerCase().contains(formats[i])) continue;
                        string = suffixes[i];
                        break;
                    }
                    if (string == null) {
                        return null;
                    }
                    String string2 = textureTile.getPath().substring(0, textureTile.getPath().lastIndexOf("."));
                    string2 = string2 + string;
                    File file = WorldWind.dataFileCache().newFile(string2);
                    if (file == null) {
                        String string3 = WorldWind.retrieveErrMsg("generic.CantCreateCacheFile") + textureTile.getPath();
                        WorldWind.logger().log(java.util.logging.Level.FINE, string3);
                        return null;
                    }
                    try {
                        WWIO.saveBuffer(byteBuffer, file);
                        return byteBuffer;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        return null;
                    }
                }
            });
            hTTPRetriever.call();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private TextureTile getContainingTile(TextureTile textureTile, Angle angle, Angle angle2, int n) {
        TextureTile[] textureTileArray;
        if (!textureTile.getSector().contains(angle, angle2)) {
            return null;
        }
        if (textureTile.getLevelNumber() == n || this.levels.isFinalLevel(textureTile.getLevelNumber())) {
            return textureTile;
        }
        for (TextureTile textureTile2 : textureTileArray = textureTile.createSubTiles(this.levels.getLevel(textureTile.getLevelNumber() + 1))) {
            TextureTile textureTile3 = this.getContainingTile(textureTile2, angle, angle2, n);
            if (textureTile3 == null) continue;
            return textureTile3;
        }
        return null;
    }

    private Color resolveColor(TextureTile textureTile, BufferedImage bufferedImage, Angle angle, Angle angle2) {
        Sector sector = textureTile.getSector();
        double d = sector.getMaxLatitude().degrees - angle.degrees;
        double d2 = angle2.degrees - sector.getMinLongitude().degrees;
        double d3 = d / sector.getDeltaLat().degrees;
        double d4 = d2 / sector.getDeltaLon().degrees;
        int n = textureTile.getLevel().getTileHeight();
        int n2 = textureTile.getLevel().getTileWidth();
        int n3 = (int)((double)(n2 - 1) * d4);
        int n4 = (int)((double)(n - 1) * d3);
        int n5 = n3 < n2 - 1 ? 1 : 0;
        int n6 = n4 < n - 1 ? 1 : 0;
        double d5 = sector.getDeltaLat().degrees / (double)(n - 1);
        double d6 = sector.getDeltaLon().degrees / (double)(n2 - 1);
        double d7 = (d - (double)n4 * d5) / d5;
        double d8 = (d2 - (double)n3 * d6) / d6;
        int n7 = bufferedImage.getRGB(n3, n4);
        int n8 = bufferedImage.getRGB(n3 + n5, n4);
        int n9 = bufferedImage.getRGB(n3 + n5, n4 + n6);
        int n10 = bufferedImage.getRGB(n3, n4 + n6);
        Color color = new Color(n7);
        Color color2 = new Color(n8);
        Color color3 = new Color(n9);
        Color color4 = new Color(n10);
        Color color5 = this.interpolateColors(color4, color3, d8);
        Color color6 = this.interpolateColors(color, color2, d8);
        return this.interpolateColors(color6, color5, d7);
    }

    private Color interpolateColors(Color color, Color color2, double d) {
        int n = (int)(d * (double)color.getRed() + (1.0 - d) * (double)color2.getRed());
        int n2 = (int)(d * (double)color.getGreen() + (1.0 - d) * (double)color2.getGreen());
        int n3 = (int)(d * (double)color.getBlue() + (1.0 - d) * (double)color2.getBlue());
        return new Color(n, n2, n3);
    }

    @Override
    public String toString() {
        return WorldWind.retrieveErrMsg("layers.TextureLayer.Name");
    }

    private static class DownloadPostProcessor
    implements RetrievalPostProcessor {
        private final TextureTile tile;
        private final TiledImageLayer layer;

        public DownloadPostProcessor(TextureTile textureTile, TiledImageLayer tiledImageLayer) {
            this.tile = textureTile;
            this.layer = tiledImageLayer;
        }

        public ByteBuffer run(Retriever retriever) {
            if (retriever == null) {
                String string = WorldWind.retrieveErrMsg("nullValue.RetrieverIsNull");
                WorldWind.logger().log(java.util.logging.Level.FINE, string);
                throw new IllegalArgumentException(string);
            }
            try {
                Object object;
                if (!retriever.getState().equals("gov.nasa.worldwind.RetrieverStatusSuccessful")) {
                    return null;
                }
                URLRetriever uRLRetriever = (URLRetriever)retriever;
                ByteBuffer byteBuffer = uRLRetriever.getBuffer();
                if (retriever instanceof HTTPRetriever) {
                    object = (HTTPRetriever)retriever;
                    if (((HTTPRetriever)object).getResponseCode() == 204) {
                        this.layer.levels.markResourceAbsent(this.tile);
                        return null;
                    }
                    if (((HTTPRetriever)object).getResponseCode() != 200) {
                        this.layer.levels.markResourceAbsent(this.tile);
                        return null;
                    }
                }
                if ((object = WorldWind.dataFileCache().newFile(this.tile.getPath())) == null) {
                    String string = WorldWind.retrieveErrMsg("generic.CantCreateCacheFile") + this.tile.getPath();
                    WorldWind.logger().log(java.util.logging.Level.FINE, string);
                    return null;
                }
                if (((File)object).exists()) {
                    return byteBuffer;
                }
                if (byteBuffer != null) {
                    String string = uRLRetriever.getContentType().toLowerCase();
                    if (string.contains("xml") || string.contains("html") || string.contains("text")) {
                        this.layer.levels.markResourceAbsent(this.tile);
                        StringBuffer stringBuffer = new StringBuffer();
                        while (byteBuffer.hasRemaining()) {
                            stringBuffer.append((char)byteBuffer.get());
                        }
                        WorldWind.logger().log(java.util.logging.Level.FINE, stringBuffer.toString());
                        return null;
                    }
                    if (string.contains("dds")) {
                        this.layer.saveBuffer(byteBuffer, (File)object);
                    } else if (string.contains("zip")) {
                        this.layer.saveBuffer(byteBuffer, (File)object);
                    } else if (((File)object).getName().endsWith(".dds")) {
                        byteBuffer = this.layer.isUseTransparentTextures() ? DDSConverter.convertToDxt3(byteBuffer, string) : DDSConverter.convertToDxt1NoTransparency(byteBuffer, string);
                        if (byteBuffer != null) {
                            this.layer.saveBuffer(byteBuffer, (File)object);
                        }
                    } else if (string.contains("image")) {
                        this.layer.saveBuffer(byteBuffer, (File)object);
                    }
                    if (byteBuffer != null) {
                        this.layer.firePropertyChange("gov.nasa.worldwind.avkey.LayerObject", null, this);
                    }
                    return byteBuffer;
                }
            }
            catch (IOException iOException) {
                this.layer.levels.markResourceAbsent(this.tile);
                String string = WorldWind.retrieveErrMsg("layers.TextureLayer.ExceptionSavingRetrievedTextureFile");
                WorldWind.logger().log(java.util.logging.Level.FINE, string + this.tile.getPath(), iOException);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RequestTask
    implements Runnable,
    Comparable<RequestTask> {
        private final TiledImageLayer layer;
        private final TextureTile tile;

        private RequestTask(TextureTile textureTile, TiledImageLayer tiledImageLayer) {
            this.layer = tiledImageLayer;
            this.tile = textureTile;
        }

        @Override
        public void run() {
            if (this.layer.isTextureInMemory(this.tile)) {
                return;
            }
            URL uRL = WorldWind.dataFileCache().findFile(this.tile.getPath(), false);
            if (uRL != null) {
                if (WWIO.isFileOutOfDate(uRL, this.tile.getLevel().getExpiryTime())) {
                    WorldWind.dataFileCache().removeFile(uRL);
                    String string = WorldWind.retrieveErrMsg("generic.DataFileExpired") + uRL;
                    WorldWind.logger().log(java.util.logging.Level.FINER, string);
                } else {
                    if (this.layer.loadTexture(this.tile, uRL)) {
                        this.layer.levels.unmarkResourceAbsent(this.tile);
                        this.layer.firePropertyChange("gov.nasa.worldwind.avkey.LayerObject", null, this);
                        return;
                    }
                    WorldWind.dataFileCache().removeFile(uRL);
                    this.layer.levels.markResourceAbsent(this.tile);
                    String string = WorldWind.retrieveErrMsg("generic.DeletedCorruptDataFile") + uRL;
                    WorldWind.logger().log(java.util.logging.Level.FINE, string);
                }
            }
            this.layer.downloadTexture(this.tile);
        }

        @Override
        public int compareTo(RequestTask requestTask) {
            if (requestTask == null) {
                String string = WorldWind.retrieveErrMsg("nullValue.RequestTaskIsNull");
                WorldWind.logger().log(java.util.logging.Level.FINE, string);
                throw new IllegalArgumentException(string);
            }
            return this.tile.getPriority() == requestTask.tile.getPriority() ? 0 : (this.tile.getPriority() < requestTask.tile.getPriority() ? -1 : 1);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            RequestTask requestTask = (RequestTask)object;
            return !(this.tile == null ? requestTask.tile != null : !this.tile.equals(requestTask.tile));
        }

        public int hashCode() {
            return this.tile != null ? this.tile.hashCode() : 0;
        }

        public String toString() {
            return this.tile.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LevelComparer
    implements Comparator<TextureTile> {
        private LevelComparer() {
        }

        @Override
        public int compare(TextureTile textureTile, TextureTile textureTile2) {
            int n;
            int n2 = textureTile.holdsTexture() ? textureTile.getLevelNumber() : textureTile.getFallbackTile().getLevelNumber();
            return n2 < (n = textureTile2.holdsTexture() ? textureTile2.getLevelNumber() : textureTile2.getFallbackTile().getLevelNumber()) ? -1 : (n2 == n ? 0 : 1);
        }
    }
}

