/*
 * Decompiled with CFR 0.152.
 */
package worldwinddemo;

import gov.nasa.worldwind.PositionEvent;
import gov.nasa.worldwind.PositionListener;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.geom.Position;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;

public class StatusBar
extends JPanel
implements PositionListener {
    private WorldWindow eventSource;
    private final JLabel latDisplay = new JLabel("");
    private final JLabel lonDisplay = new JLabel("Off globe");
    private final JLabel eleDisplay = new JLabel("");

    public StatusBar() {
        super(new GridLayout(1, 0));
        final JLabel jLabel = new JLabel("Downloading");
        this.latDisplay.setHorizontalAlignment(0);
        this.lonDisplay.setHorizontalAlignment(0);
        this.eleDisplay.setHorizontalAlignment(0);
        this.add(new JLabel(""));
        this.add(this.latDisplay);
        this.add(this.lonDisplay);
        this.add(this.eleDisplay);
        this.add(jLabel);
        jLabel.setHorizontalAlignment(0);
        jLabel.setForeground(new Color(255, 0, 0, 0));
        Timer timer = new Timer(50, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Color color = jLabel.getForeground();
                int n = color.getAlpha();
                n = WorldWind.retrievalService().hasActiveTasks() ? (n == 255 ? 255 : (n < 16 ? 16 : Math.min(255, n + 20))) : Math.max(0, n - 20);
                jLabel.setForeground(new Color(255, 0, 0, n));
            }
        });
        timer.start();
    }

    public void setEventSource(WorldWindow worldWindow) {
        if (this.eventSource != null) {
            this.eventSource.removePositionListener(this);
        }
        if (worldWindow != null) {
            worldWindow.addPositionListener(this);
        }
        this.eventSource = worldWindow;
    }

    public void moved(PositionEvent positionEvent) {
        this.handleCursorPositionChange(positionEvent);
    }

    public WorldWindow getEventSource() {
        return this.eventSource;
    }

    private void handleCursorPositionChange(PositionEvent positionEvent) {
        Position position = positionEvent.getPosition();
        if (position != null) {
            String string = String.format("Latitude %7.3f\u00b0", position.getLatitude().getDegrees());
            String string2 = String.format("Longitude %7.3f\u00b0", position.getLongitude().getDegrees());
            String string3 = String.format("Elevation %7d meters", (int)position.getElevation());
            this.latDisplay.setText(string);
            this.lonDisplay.setText(string2);
            this.eleDisplay.setText(string3);
        } else {
            this.latDisplay.setText("");
            this.lonDisplay.setText("Off globe");
            this.eleDisplay.setText("");
        }
    }
}

