/*
Copyright (C) 2001, 2006 United States Government
as represented by the Administrator of the
National Aeronautics and Space Administration.
All Rights Reserved.
*/
package gov.nasa.worldwind;

/**
 * @author Tom Gaskins
 * @version $Id: AVKey.java 1792 2007-05-08 21:28:37Z tgaskins $
 */
public interface AVKey // TODO: Eliminate unused constants, if any
{
    final String CACHE_SIZE = "gov.nasa.worldwind.avkey.CacheSize";
    final String CACHE_LOW_WATER = "gov.nasa.worldwind.avkey.CacheLowWater";

    final String ELEVATION_MODEL = "gov.nasa.worldwind.avkey.ElevationModel";
    final String EXTENT = "gov.nasa.worldwind.avkey.Extent";

    final String DATA_FILE_CACHE_CLASS_NAME = "gov.nasa.worldwind.avkey.DataFileCacheClassName";
    final String DATA_FILE_CACHE_CONFIGURATION_FILE_NAME = "gov.nasa.worldwind.avkey.DataFileCacheConfigurationFileName";

    final String DISPLAY_NAME = "gov.nasa.worldwind.avkey.DisplayName";
    final String DISPLAY_ICON = "gov.nasa.worldwind.avkey.DisplayIcon";

    final String FOV = "gov.nasa.worldwind.avkey.FieldOfView";

    final String FRAME_CONTROLLER = "gov.nasa.worldwind.avkey.FrameControllerObject";
    final String FRAME_CONTROLLER_CLASS_NAME = "gov.nasa.worldwind.avkey.FrameControllerClassName";

    final String GLOBE = "gov.nasa.worldwind.avkey.GlobeObject";
    final String GLOBE_CLASS_NAME = "gov.nasa.worldwind.avkey.GlobeClassName";

    final String INITIAL_LATITUDE = "gov.nasa.worldwind.avkey.InitialLatitude";
    final String INITIAL_LONGITUDE = "gov.nasa.worldwind.avkey.InitialLongitude";
    final String INPUT_HANDLER_CLASS_NAME = "gov.nasa.worldwind.avkey.InputHandlerClassName";

    final String LAYER = "gov.nasa.worldwind.avkey.LayerObject";
    final String LAYERS = "gov.nasa.worldwind.avkey.LayersObject";
    final String LAYERS_CLASS_NAMES = "gov.nasa.worldwind.avkey.LayersClassName";

    final String LOGGER_NAME = "gov.nasa.worldwind.avkey.LoggerName";

    final String MEMORY_CACHE_CLASS_NAME = "gov.nasa.worldwind.avkey.MemoryCacheClassName";

    final String MODEL = "gov.nasa.worldwind.avkey.ModelObject";
    final String MODEL_CLASS_NAME = "gov.nasa.worldwind.avkey.ModelClassName";

    final String PICKED_OBJECT              = "gov.nasa.worldwind.avkey.PickedObject";
    final String PICKED_OBJECT_ID           = "gov.nasa.worldwind.avkey.PickedObject.ID";
    final String PICKED_OBJECT_PARENT_LAYER = "gov.nasa.worldwind.avkey.PickedObject.ParentLayer";
    final String PICKED_OBJECT_PARENT_LAYER_NAME = "gov.nasa.worldwind.avkey.PickedObject.ParentLayer.Name";

    final String POSITION = "gov.nasa.worldwind.avkey.Position";

    final String RETRIEVAL_POOL_SIZE = "gov.nasa.worldwind.avkey.RetrievalPoolSize";
    final String RETRIEVAL_QUEUE_SIZE = "gov.nasa.worldwind.avkey.RetrievalQueueSize";
    final String RETRIEVAL_QUEUE_STALE_REQUEST_LIMIT = "gov.nasa.worldwind.avkey.RetrievalStaleRequestLimit";
    final String RETRIEVAL_SERVICE_CLASS_NAME = "gov.nasa.worldwind.avkey.RetrievalServiceClassName";

    final String RETRIEVER_STATE = "gov.nasa.worldwind.avkey.RetrieverState";

    final String SCENE_CONTROLLER = "gov.nasa.worldwind.avkey.SceneControllerObject";
    final String SCENE_CONTROLLER_CLASS_NAME = "gov.nasa.worldwind.avkey.SceneControllerClassName";
    final String SECTOR = "gov.nasa.worldwind.avKey.Sector";
    final String SENDER = "gov.nasa.worldwind.avkey.Sender";

    final String THREADED_TASK_POOL_SIZE = "gov.nasa.worldwind.avkey.ThreadedTaskPoolSize";
    final String THREADED_TASK_QUEUE_SIZE = "gov.nasa.worldwind.avkey.ThreadedTaskQueueSize";
    final String THREADED_TASK_SERVICE_CLASS_NAME = "gov.nasa.worldwind.avkey.ThreadedTaskServiceClassName";

    final String URL_CONNECT_TIMEOUT = "gov.nasa.worldwind.avkey.URLConnectTimeout";
    final String URL_READ_TIMEOUT = "gov.nasa.worldwind.avkey.URLReadTimeout";

    final String VERTICAL_EXAGGERATION = "gov.nasa.worldwind.avkey.VerticalExaggeration";
    final String VIEW = "gov.nasa.worldwind.avkey.ViewObject";
    final String VIEW_CLASS_NAME = "gov.nasa.worldwind.avkey.ViewClassName";

}
