/*
Copyright (C) 2001, 2006 United States Government
as represented by the Administrator of the
National Aeronautics and Space Administration.
All Rights Reserved.
*/
package gov.nasa.worldwind;

/**
 * @author Tom Gaskins
 * @version $Id: BasicDataFileCache.java 1792 2007-05-08 21:28:37Z tgaskins $
 */
public class BasicDataFileCache extends AbstractFileCache
{
    public BasicDataFileCache()
    {
        String cachePathName = Configuration.getStringValue(AVKey.DATA_FILE_CACHE_CONFIGURATION_FILE_NAME);
        if (cachePathName == null)
        {
            String message = WorldWind.retrieveErrMsg("FileCache.NoConfiguration");
            WorldWind.logger().log(java.util.logging.Level.FINE, message);
            throw new IllegalStateException(message);
        }

        java.io.InputStream is = this.getClass().getClassLoader().getResourceAsStream(cachePathName);
        if (is == null)
        {
            String message = WorldWind.retrieveErrMsg("FileCache.ConfigurationNotFound");
            WorldWind.logger().log(java.util.logging.Level.FINE, message);
            throw new IllegalStateException(message);
        }

        this.initialize(is);
    }
}
