/*
Copyright (C) 2001, 2006 United States Government
as represented by the Administrator of the
National Aeronautics and Space Administration.
All Rights Reserved.
*/
package gov.nasa.worldwind;

import java.net.*;
import java.nio.*;

/**
 * @author Tom Gaskins
 * @version $Id: HTTPRetriever.java 1724 2007-05-05 04:05:40Z tgaskins $
 */
public class HTTPRetriever extends URLRetriever
{
    private int responseCode;
    private String responseMessage;

    public HTTPRetriever(URL url, RetrievalPostProcessor postProcessor)
    {
        super(url, postProcessor);
    }

    public int getResponseCode()
    {
        return this.responseCode;
    }

    public String getResponseMessage()
    {
        return this.responseMessage;
    }

    protected ByteBuffer doRead(URLConnection connection) throws Exception
    {
        if (connection == null)
        {
            String msg = WorldWind.retrieveErrMsg("nullValue.ConnectionIsNull");
            WorldWind.logger().log(java.util.logging.Level.FINE, msg);
            throw new IllegalArgumentException(msg);
        }

        HttpURLConnection htpc = (HttpURLConnection) connection;
        this.responseCode = htpc.getResponseCode();
        this.responseMessage = htpc.getResponseMessage();
        String contentType = connection.getContentType();

        WorldWind.logger().log(java.util.logging.Level.FINER, WorldWind.retrieveErrMsg("HTTPRetriever.ResponseCode")
            + this.responseCode
            + WorldWind.retrieveErrMsg("HTTPRetriever.ResponseContentLength") + connection.getContentLength()
            + (contentType != null ? " " + contentType : " content type not returned")
            + WorldWind.retrieveErrMsg("HTTPRetriever.Retrieving") + connection.getURL());

        if (this.responseCode == HttpURLConnection.HTTP_OK)
            return super.doRead(connection);

        return null;
    }
}
