/*
Copyright (C) 2001, 2006 United States Government
as represented by the Administrator of the
National Aeronautics and Space Administration.
All Rights Reserved.
*/
package gov.nasa.worldwind;

import java.util.*;

/**
 * @author tag
 * @version $Id: RenderingEvent.java 1764 2007-05-07 20:01:57Z tgaskins $
 */
public class RenderingEvent extends EventObject
{
    public static final String BEGIN = "gov.nasa.worldwind.RenderingEvent.BeginStage";
    public static final String END = "gov.nasa.worldwind.RenderingEvent.EndStage";

    private String stage;

    public RenderingEvent(Object source, String stage)
    {
        super(source);
        this.stage = stage;
    }

    public String getStage()
    {
        return this.stage != null ? this.stage : "gov.nasa.worldwind.RenderingEvent.UnknownStage";
    }

    @Override
    public String toString()
    {
        return this.getClass().getName() + " "
            + this.stage != null ? this.stage : WorldWind.retrieveErrMsg("generic.unknown");
    }
}
