/*
Copyright (C) 2001, 2006 United States Government
as represented by the Administrator of the
National Aeronautics and Space Administration.
All Rights Reserved.
*/
package gov.nasa.worldwind;

/**
 * @author Tom Gaskins
 * @version $Id: SceneController.java 1722 2007-05-05 04:03:46Z tgaskins $
 */
public interface SceneController extends WWObject
{
    public Model getModel();

    public void setModel(Model model);

    public View getView();

    public void setView(View view);

    public FrameController getFrameController();

    public void setFrameController(FrameController frameController);

    public void repaint();

    void setVerticalExaggeration(double verticalExaggeration);

    double getVerticalExaggeration();

    PickedObjectList getPickedObjectList();

    gov.nasa.worldwind.PickedObjectList pick(java.awt.Point pickPoint);

    double getFramesPerSecond();

    double getFrameTime();
}
