/*
Copyright (C) 2001, 2006 United States Government
as represented by the Administrator of the
National Aeronautics and Space Administration.
All Rights Reserved.
*/
package gov.nasa.worldwind.formats.gpx;

import gov.nasa.worldwind.*;

/**
 * @author tag
 * @version $Id: GpxTrack.java 522 2007-01-22 01:00:26Z ericdalgliesh $
 */
public class GpxTrack extends gov.nasa.worldwind.formats.gpx.ElementParser implements gov.nasa.worldwind.Track
{
    private String name;
    private int numPoints = -1;
    private java.util.List<gov.nasa.worldwind.TrackSegment> segments =
        new java.util.ArrayList<gov.nasa.worldwind.TrackSegment>();

    @SuppressWarnings({"UNUSED_SYMBOL", "UnusedDeclaration"})
    public GpxTrack(String uri, String lname, String qname, org.xml.sax.Attributes attributes)
    {
        super("trk");
        // don't validate uri, lname, qname or attributes - they aren't used.
    }

    public java.util.List<gov.nasa.worldwind.TrackSegment> getSegments()
    {
        return segments;
    }

    public String getName()
    {
        return name;
    }

    public int getNumPoints()
    {
        if (this.segments == null)
            return 0;

        if (this.numPoints >= 0)
            return this.numPoints;

        this.numPoints = 0;
        for (gov.nasa.worldwind.TrackSegment segment : this.segments)
        {
            //noinspection UNUSED_SYMBOL,UnusedDeclaration
            for (gov.nasa.worldwind.TrackPoint point : segment.getPoints())
            {
                ++this.numPoints;
            }
        }

        return this.numPoints;
    }

    /**
     * @param uri
     * @param lname
     * @param qname
     * @param attributes
     * @throws IllegalArgumentException if <code>lname</code> is null
     * @throws org.xml.sax.SAXException
     */
    @Override
    public void doStartElement(String uri, String lname, String qname, org.xml.sax.Attributes attributes)
        throws org.xml.sax.SAXException
    {
        // don't validate uri, qname or attributes - they aren't used
        if (lname == null)
        {
            String msg = WorldWind.retrieveErrMsg("nullValue.LNameIsNull");
            WorldWind.logger().log(java.util.logging.Level.FINE, msg);
            throw new IllegalArgumentException(msg);
        }
        if (qname == null)
        {
            String msg = WorldWind.retrieveErrMsg("nullValue.QNameIsNull");
            WorldWind.logger().log(java.util.logging.Level.FINE, msg);
            throw new IllegalArgumentException(msg);
        }
        if (uri == null)
        {
            String msg = WorldWind.retrieveErrMsg("nullValue.URIIsNull");
            WorldWind.logger().log(java.util.logging.Level.FINE, msg);
            throw new IllegalArgumentException(msg);
        }
        if (attributes == null)
        {
            String msg = WorldWind.retrieveErrMsg("nullValue.AttributesIsNull");
            WorldWind.logger().log(java.util.logging.Level.FINE, msg);
            throw new IllegalArgumentException(msg);
        }

        if (lname.equalsIgnoreCase("trkSeg"))
        {
            this.currentElement = new GpxTrackSegment(uri, lname, qname, attributes);
            this.segments.add((GpxTrackSegment) this.currentElement);
        }
    }

    /**
     * @param uri
     * @param lname
     * @param qname
     * @throws IllegalArgumentException if <code>lname</code> is null
     * @throws org.xml.sax.SAXException
     */
    @Override
    public void doEndElement(String uri, String lname, String qname) throws org.xml.sax.SAXException
    {
        // don't validate uri or qname - they aren't used
        if (lname == null)
        {
            String msg = WorldWind.retrieveErrMsg("nullValue.LNameIsNull");
            WorldWind.logger().log(java.util.logging.Level.FINE, msg);
            throw new IllegalArgumentException(msg);
        }
        if (lname.equalsIgnoreCase("name"))
        {
            this.name = this.currentCharacters;
        }
    }
}
