/*
Copyright (C) 2001, 2006 United States Government
as represented by the Administrator of the
National Aeronautics and Space Administration.
All Rights Reserved.
*/
package gov.nasa.worldwind.formats.gpx;

import gov.nasa.worldwind.*;

/**
 * @author tag
 * @version $Id: GpxTrackSegment.java 524 2007-01-22 01:06:31Z ericdalgliesh $
 */
public class GpxTrackSegment extends gov.nasa.worldwind.formats.gpx.ElementParser
    implements gov.nasa.worldwind.TrackSegment
{
    private java.util.List<gov.nasa.worldwind.TrackPoint> points =
        new java.util.ArrayList<gov.nasa.worldwind.TrackPoint>();

    public GpxTrackSegment(String uri, String lname, String qname, org.xml.sax.Attributes attributes)
    {
        super("trkseg");

        // dont' validate uri, lname, qname or attributes as they aren't used.
    }

    public java.util.List<gov.nasa.worldwind.TrackPoint> getPoints()
    {
        return this.points;
    }

    /**
     * @param uri
     * @param lname
     * @param qname
     * @param attributes
     * @throws IllegalArgumentException if any parameter is null
     * @throws org.xml.sax.SAXException
     */
    @Override
    public void doStartElement(String uri, String lname, String qname, org.xml.sax.Attributes attributes)
        throws org.xml.sax.SAXException
    {
        if (lname == null)
        {
            String msg = WorldWind.retrieveErrMsg("nullValue.LNameIsNull");
            WorldWind.logger().log(java.util.logging.Level.FINE, msg);
            throw new IllegalArgumentException(msg);
        }

        if (uri == null)
        {
            String msg = WorldWind.retrieveErrMsg("nullValue.URIIsNull");
            WorldWind.logger().log(java.util.logging.Level.FINE, msg);
            throw new IllegalArgumentException(msg);
        }
        if (qname == null)
        {
            String msg = WorldWind.retrieveErrMsg("nullValue.QNameIsNull");
            WorldWind.logger().log(java.util.logging.Level.FINE, msg);
            throw new IllegalArgumentException(msg);
        }
        if (attributes == null)
        {
            String msg = WorldWind.retrieveErrMsg("nullValue.AttributesIsNull");
            WorldWind.logger().log(java.util.logging.Level.FINE, msg);
            throw new IllegalArgumentException(msg);
        }

        if (lname.equalsIgnoreCase("trkpt"))
        {
            this.currentElement = new gov.nasa.worldwind.formats.gpx.GpxTrackPoint(uri, lname, qname, attributes);
            this.points.add((gov.nasa.worldwind.formats.gpx.GpxTrackPoint) this.currentElement);
        }
    }
}
