package gov.nasa.worldwind.formats.nitfs;
/*
Copyright (C) 2001, 2007 United States Government
as represented by the Administrator of the
National Aeronautics and Space Administration.
All Rights Reserved.
*/

/**
 * @author Lado Garakanidze
 * @version $Id: NitfsSegmentType Mar 29, 2007 6:33:57 PM lado
 */
public enum NitfsSegmentType
{
    ImageSegment                (6, 10),
    SymbolSegment               (4, 6),
    LabelSegment                (4, 3),
    TextSegment                 (4, 5),
    DataExtensionSegment        (4, 9),
    ReservedExtensionSegment    (4, 7),
    UserDefinedHeaderSegment    (0, 0),
    ExtendedHeaderSegment       (0, 0);

    private final int fieldHeaderLengthSize;
    private final int fieldDataLengthSize;

    private NitfsSegmentType(int fieldHeaderLengthSize, int fieldDataLengthSize)
    {
        this.fieldHeaderLengthSize = fieldHeaderLengthSize;
        this.fieldDataLengthSize = fieldDataLengthSize;
    }

    public int getHeaderLengthSize() { return fieldHeaderLengthSize; }
    public int getDataLengthSize() { return fieldDataLengthSize; }
}
