package gov.nasa.worldwind.formats.nitfs;

import gov.nasa.worldwind.*;
import gov.nasa.worldwind.formats.rpf.*;
/*
Copyright (C) 2001, 2007 United States Government
as represented by the Administrator of the
National Aeronautics and Space Administration.
All Rights Reserved.
*/

/**
 * @author Lado Garakanidze
 * @version $Id: UserDefinedImageSubheader Mar 31, 2007 9:42:33 PM
 */
public class UserDefinedImageSubheader
{
    public short getOverflow()
    {
        return this.overflow;
    }

    public String getTag()
    {
        return this.tag;
    }

    public int getDataLength()
    {
        return this.dataLength;
    }

    public RpfFrameFileComponents getRpfFrameFileComponents()
    {
        return this.rpfFrameFileComponents;
    }

    private RpfFrameFileComponents rpfFrameFileComponents = null;

    private short    overflow;
    private String   tag;
    private int      dataLength;

    public UserDefinedImageSubheader(java.nio.ByteBuffer buffer) throws NitfsRuntimeException
    {
        this.overflow = NitfsUtil.getShortNumeric(buffer, 3);
        this.tag = NitfsUtil.getString(buffer, 6);
        this.dataLength = NitfsUtil.getShortNumeric(buffer, 5);

        if(0 < this.dataLength)
        {
            if(StringUtil.Equals(tag, RpfFrameFileComponents.DATA_TAG))
                this.rpfFrameFileComponents = new RpfFrameFileComponents(buffer);
            else
                throw new NitfsRuntimeException("NitfsReader.UnknownOrUnsupportedUserDefinedImageSubheader");
        }
    }
}
