/*
Copyright (C) 2001, 2006 United States Government
as represented by the Administrator of the
National Aeronautics and Space Administration.
All Rights Reserved.
*/
package gov.nasa.worldwind.geom;

/**
 * The interface World Wind uses to interact with matrices. This interface can be implemented by an application's
 * own matrix classes. World Wind will then use instances of those classes for matrix manipulation.
 * @author Tom Gaskins
 * @version $Id: Matrix.java 1749 2007-05-06 19:48:14Z tgaskins $
 */
public interface Matrix
{
    Matrix setToIdentity();
    Matrix rotate(Angle rotation, double axisX, double axisY, double axisZ);
    Matrix rotateX(Angle rotation);
    Matrix rotateY(Angle rotation);
    Matrix rotateZ(Angle rotation);
    Matrix translate(double x, double y, double z);
    Matrix translate(Point p);
    Matrix multiply(Matrix m);
    Matrix add(Matrix m);
    Matrix getInverse();
    Matrix getTranspose();
    double determinant();
    double[] getEntries();
    boolean isOrthonormal();
    Point transform(Point p);
}
