/*
Copyright (C) 2001, 2006 United States Government
as represented by the Administrator of the
National Aeronautics and Space Administration.
All Rights Reserved.
*/
package gov.nasa.worldwind.geom;

import java.awt.*;

/**
 * @author tag
 * @version $Id: SurfacePolyline.java 1448 2007-04-12 00:20:38Z tgaskins $
 */
public class SurfacePolyline extends SurfacePolygon
{
    public SurfacePolyline(Iterable<LatLon> positions, Color color, Color borderColor)
    {
        super(positions, color, borderColor);
        this.setDrawInterior(false);
        this.setStroke(new BasicStroke(3f));
    }

    public SurfacePolyline(Iterable<LatLon> positions)
    {
        super(positions);
        this.setDrawInterior(false);
        this.setPaint(new Color(1f, 1f, 0f, .8f));
        this.setStroke(new BasicStroke(3f));
    }
}
