/*
Copyright (C) 2001, 2006 United States Government
as represented by the Administrator of the
National Aeronautics and Space Administration.
All Rights Reserved.
*/
package gov.nasa.worldwind.geom;

import gov.nasa.worldwind.*;

import java.awt.*;
import java.awt.image.*;
import java.util.*;

/**
 * @author tag
 * @version $Id: SurfaceQuadrilateral.java 1680 2007-05-02 00:30:25Z tgaskins $
 */
public class SurfaceQuadrilateral extends SurfacePolygon
{

    public SurfaceQuadrilateral(Sector sector, Color color, Color borderColor)
    {
        super(makePositions(sector), color, borderColor);
    }

    public SurfaceQuadrilateral(Sector sector)
    {
        super(makePositions(sector), null, null);
    }

    private static Iterable<LatLon> makePositions(Sector sector)
    {
        if (sector == null)
        {
            String message = WorldWind.retrieveErrMsg("nullValue.SectorIsNull");
            WorldWind.logger().log(java.util.logging.Level.FINE, message);
            throw new IllegalArgumentException(message);
        }

        ArrayList<LatLon> positions = new ArrayList<LatLon>(5);

        positions.add(0, new LatLon(sector.getMinLatitude(), sector.getMinLongitude()));
        positions.add(1, new LatLon(sector.getMinLatitude(), sector.getMaxLongitude()));
        positions.add(2, new LatLon(sector.getMaxLatitude(), sector.getMaxLongitude()));
        positions.add(3, new LatLon(sector.getMaxLatitude(), sector.getMinLongitude()));
        positions.add(4, new LatLon(sector.getMinLatitude(), sector.getMinLongitude()));

        return positions;
    }
}
