/*
Copyright (C) 2001, 2006 United States Government
as represented by the Administrator of the
National Aeronautics and Space Administration.
All Rights Reserved.
*/
package gov.nasa.worldwind.layers.Earth;

import gov.nasa.worldwind.*;
import gov.nasa.worldwind.geom.*;
import gov.nasa.worldwind.layers.*;

/**
 * @author Tom Gaskins
 * @version $Id: BMNGSurfaceLayer.java 1731 2007-05-05 05:57:22Z tgaskins $
 */
public class BMNGSurfaceLayer extends TiledImageLayer
{
    public BMNGSurfaceLayer()
    {
        super(makeLevels());
        this.setForceLevelZeroLoads(true);
        this.setRetainLevelZeroTiles(true);
    }

    private static LevelSet makeLevels()
    {
        AVList params = new AVListImpl();

        params.setValue(Level.TILE_WIDTH, 512);
        params.setValue(Level.TILE_HEIGHT, 512);
        params.setValue(Level.CACHE_NAME, "Earth/BMNG/BMNG(Shaded + Bathymetry) Tiled - Version 1.1 - 5.2004");
        params.setValue(Level.SERVICE, "http://worldwind25.arc.nasa.gov/tile/tile.aspx");
        params.setValue(Level.DATASET_NAME, "bmng.topo.bathy.200405dds");
        params.setValue(Level.FORMAT_SUFFIX, ".dds");
        params.setValue(Level.NUM_LEVELS, 5);
        params.setValue(Level.NUM_EMPTY_LEVELS, 0);
        params.setValue(Level.LEVEL_ZERO_TILE_DELTA, new LatLon(Angle.fromDegrees(36d), Angle.fromDegrees(36d)));
        params.setValue(AVKey.SECTOR, Sector.FULL_SPHERE);

        return new LevelSet(params);
    }

    @Override
    public String toString()
    {
        return WorldWind.retrieveErrMsg("layers.Earth.BlueMarbleLayer.Name");
    }
}
