/*
Copyright (C) 2001, 2006 United States Government
as represented by the Administrator of the
National Aeronautics and Space Administration.
All Rights Reserved.
*/
package gov.nasa.worldwind.layers.Earth;

import gov.nasa.worldwind.layers.*;
import gov.nasa.worldwind.*;
import gov.nasa.worldwind.geom.*;

import java.net.*;

/**
 * @author tag
 * @version $Id: PoliticalBoundariesLayer.java 1731 2007-05-05 05:57:22Z tgaskins $
 */
public class PoliticalBoundariesLayer extends TiledImageLayer
{
    public PoliticalBoundariesLayer()
    {
        super(makeLevels(new URLBuilder()));
        this.setUseTransparentTextures(true);
    }

    private static LevelSet makeLevels(URLBuilder urlBuilder)
    {
        AVList params = new AVListImpl();

        params.setValue(Level.TILE_WIDTH, 512);
        params.setValue(Level.TILE_HEIGHT, 512);
        params.setValue(Level.CACHE_NAME, "Earth/PoliticalBoundaries");
        params.setValue(Level.SERVICE, "http://worldwind21.arc.nasa.gov/geoserver/wms");
        params.setValue(Level.DATASET_NAME, "topp:cia");
        params.setValue(Level.FORMAT_SUFFIX, ".png");
        params.setValue(Level.NUM_LEVELS, 13);
        params.setValue(Level.NUM_EMPTY_LEVELS, 0);
        params.setValue(Level.LEVEL_ZERO_TILE_DELTA, new LatLon(Angle.fromDegrees(36d), Angle.fromDegrees(36d)));
        params.setValue(AVKey.SECTOR, Sector.FULL_SPHERE);
        params.setValue(Level.TILE_URL_BUILDER, urlBuilder);

        return new LevelSet(params);
    }

    private static class URLBuilder implements Level.TileURLBuilder
    {
        public URL getURL(Tile tile) throws MalformedURLException
        {
            StringBuffer sb = new StringBuffer(tile.getLevel().getService());
            if (sb.lastIndexOf("?") != sb.length() - 1)
                sb.append("?");
            sb.append("request=GetMap");
            sb.append("&layers=");
            sb.append(tile.getLevel().getDataset());
            sb.append("&srs=EPSG:4326");
            sb.append("&width=");
            sb.append(tile.getLevel().getTileWidth());
            sb.append("&height=");
            sb.append(tile.getLevel().getTileHeight());

            Sector s = tile.getSector();
            sb.append("&bbox=");
            sb.append(s.getMinLongitude().getDegrees());
            sb.append(",");
            sb.append(s.getMinLatitude().getDegrees());
            sb.append(",");
            sb.append(s.getMaxLongitude().getDegrees());
            sb.append(",");
            sb.append(s.getMaxLatitude().getDegrees());

            sb.append("&format=image/png");
            sb.append("&styles=countryboundaries");
//            sb.append("&bgcolor=0x000000");
            sb.append("&transparent=true");

            return new java.net.URL(sb.toString());
        }
    }

    @Override
    public String toString()
    {
        return gov.nasa.worldwind.WorldWind.retrieveErrMsg("layers.Earth.PoliticalBoundaries.Name");
    }
}
