/*
Copyright (C) 2001, 2006 United States Government
as represented by the Administrator of the
National Aeronautics and Space Administration.
All Rights Reserved.
*/
package gov.nasa.worldwind.layers.Earth;

import gov.nasa.worldwind.*;
import gov.nasa.worldwind.layers.*;
import gov.nasa.worldwind.geom.*;

/**
 * @author tag
 * @version $Id: USGSUrbanAreaOrtho.java 1735 2007-05-05 09:50:26Z tgaskins $
 */
public class USGSUrbanAreaOrtho extends TiledImageLayer
{
    public USGSUrbanAreaOrtho()
    {
        super(makeLevels());
        this.setMaxActiveAltitude(35e3d);
    }

    private static LevelSet makeLevels()
    {
        AVList params = new AVListImpl();

        params.setValue(Level.TILE_WIDTH, 512);
        params.setValue(Level.TILE_HEIGHT, 512);
        params.setValue(Level.CACHE_NAME, "Earth/USGS Urban Area Ortho");
        params.setValue(Level.SERVICE, "http://worldwind25.arc.nasa.gov/tile/tile.aspx");
        params.setValue(Level.DATASET_NAME, "104dds");
        params.setValue(Level.FORMAT_SUFFIX, ".dds");
        params.setValue(Level.NUM_LEVELS, 12);
        params.setValue(Level.NUM_EMPTY_LEVELS, 2);

        Angle levelZeroDelta = Angle.fromDegrees(3.2);
        params.setValue(Level.LEVEL_ZERO_TILE_DELTA, new LatLon(levelZeroDelta, levelZeroDelta));

        params.setValue(AVKey.SECTOR, new Sector(Angle.fromDegrees(17.84), Angle.fromDegrees(71.55),
            Angle.fromDegrees(-168.67), Angle.fromDegrees(-65.15)));

        return new LevelSet(params);
    }

    @Override
    public String toString()
    {
        return WorldWind.retrieveErrMsg("layers.Earth.USGSUrbanAreaOrtho.Name");
    }
}
