/*
Copyright (C) 2001, 2006 United States Government
as represented by the Administrator of the
National Aeronautics and Space Administration.
All Rights Reserved.
*/
package gov.nasa.worldwind.layers;

import gov.nasa.worldwind.*;
import gov.nasa.worldwind.geom.*;

/**
 * @author tag
 * @version $Id$
 */
public class IconLayer extends AbstractLayer
{
    private final java.util.Collection<WWIcon> icons = new java.util.ArrayList<WWIcon>();
    private java.util.Iterator<WWIcon> iconIterator;
    private IconRenderer iconRenderer = new IconRenderer();
    private Pedestal pedestal;

    public IconLayer()
    {
    }

    public void setIcons(java.util.Iterator<WWIcon> iconIterator)
    {
        this.iconIterator = iconIterator;
    }

    public void addIcon(WWIcon icon)
    {
        if (icon == null)
        {
            String msg = WorldWind.retrieveErrMsg("nullValue.Icon");
            WorldWind.logger().log(java.util.logging.Level.FINE, msg);
            throw new IllegalArgumentException(msg);
        }

        this.icons.add(icon);
    }

    public void removeIcon(WWIcon icon)
    {
        if (icon == null)
        {
            String msg = WorldWind.retrieveErrMsg("nullValue.Icon");
            WorldWind.logger().log(java.util.logging.Level.FINE, msg);
            throw new IllegalArgumentException(msg);
        }

        this.icons.remove(icon);
    }

    public java.util.Collection<WWIcon> getIcons()
    {
        return this.icons;
    }

    public void dispose()
    {
        this.iconRenderer.dispose();
    }

    public Pedestal getPedestal()
    {
        return pedestal;
    }

    public void setPedestal(Pedestal pedestal)
    {
        this.pedestal = pedestal;
    }

    @Override
    protected void doPick(DrawContext dc, java.awt.Point pickPoint)
    {
        if (this.iconIterator == null)
            this.iconIterator = this.icons.iterator();

        this.iconRenderer.setPedestal(this.pedestal);
        this.iconRenderer.pick(dc, this.iconIterator, pickPoint, this);

        this.iconIterator = null;
    }

    @Override
    protected void doRender(DrawContext dc)
    {
        if (this.iconIterator == null)
            this.iconIterator = this.icons.iterator();

        this.iconRenderer.setPedestal(this.pedestal);
        this.iconRenderer.render(dc, this.iconIterator);

        this.iconIterator = null;
    }

    @Override
    public String toString()
    {
        return WorldWind.retrieveErrMsg("layers.IconLayer.Name");
    }
}
