/*
Copyright (C) 2001, 2006 United States Government
as represented by the Administrator of the
National Aeronautics and Space Administration.
All Rights Reserved.
*/
package gov.nasa.worldwind;

import gov.nasa.worldwind.geom.*;

/**
 * @author Tom Gaskins
 * @version $Id: Globe.java 1783 2007-05-08 06:31:19Z tgaskins $
 */
public interface Globe extends WWObject, Extent
{
    Point computePointFromPosition(Angle latitude, Angle longitude, double metersElevation);

    Point computeSurfaceNormalAtPoint(Point p);

    ElevationModel getElevationModel();

    Extent getExtent();

    double getEquatorialRadius();

    double getPolarRadius();

    double getMaximumRadius();

    double getRadiusAt(Angle latitude, Angle longitude);

    double getElevation(Angle latitude, Angle longitude);

    double getMaxElevation();

    double getMinElevation();

    Position getIntersectionPosition(Line line);

    double getEccentricitySquared();

    Position computePositionFromPoint(Point point);

    Point computePointFromPosition(Position position);
}
