package gov.nasa.worldwind;

/*
Copyright (C) 2001, 2006 United States Government
as represented by the Administrator of the
National Aeronautics and Space Administration.
All Rights Reserved.
*/

/**
 * @author Tom Gaskins
 * @version $Id: LayerList.java 1467 2007-04-14 01:24:51Z tgaskins $
 */
public class LayerList extends WWObjectImpl implements Iterable<Layer>
{
    private java.util.List<Layer> layerList = new java.util.ArrayList<Layer>();

    public LayerList()
    {
    }

    public LayerList(Layer[] layers)
    {
        if (layers == null)
        {
            String message = WorldWind.retrieveErrMsg("nullValue.LayersIsNull");
            WorldWind.logger().log(java.util.logging.Level.FINE, message);
            throw new IllegalArgumentException(message);
        }
        for (Layer layer : layers)
        {
            this.add(layer);
        }
    }

    public void add(Layer layer)
    {
        if (layer == null)
        {
            String message = WorldWind.retrieveErrMsg("nullValue.LayerIsNull");
            WorldWind.logger().log(java.util.logging.Level.FINE, message);
            throw new IllegalArgumentException(message);
        }

        if (this.layerList.contains(layer))
            return;

        this.layerList.add(layer);
        layer.addPropertyChangeListener(this);
        this.firePropertyChange(AVKey.LAYERS, null, this.layerList); // TODO: send old layer list content
    }

    public void remove(Layer layer)
    {
        if (layer == null)
        {
            String msg = WorldWind.retrieveErrMsg("nullValue.LayerIsNull");
            WorldWind.logger().log(java.util.logging.Level.FINE, msg);
            throw new IllegalArgumentException(msg);
        }

        if (!this.layerList.contains(layer))
            return;

        layer.removePropertyChangeListener(this);
        this.layerList.remove(layer);
        this.firePropertyChange(AVKey.LAYERS, null, this.layerList); // TODO: send old layer list content
    }

    public java.util.Iterator<Layer> iterator()
    {
        return this.layerList.iterator();
    }

    public int getSize()
    {
        return this.layerList.size();
    }

    @Override
    public String toString()
    {
        String r = "";
        for (Layer l : this.layerList)
        {
            r += l.toString() + ", ";
        }
        return r;
    }
}
