/*
Copyright (C) 2001, 2006 United States Government
as represented by the Administrator of the
National Aeronautics and Space Administration.
All Rights Reserved.
*/
package gov.nasa.worldwind;

/**
 * @author Tom Gaskins
 * @version $Id: Model.java 1561 2007-04-21 09:29:58Z tgaskins $
 */
public interface Model extends WWObject
{
    gov.nasa.worldwind.geom.Extent getExtent();

    Globe getGlobe();

    LayerList getLayers();

    void setGlobe(Globe globe);

    void setLayers(LayerList layers);

    Tessellator getTessellator();

    void setTessellator(Tessellator tessellator);

    void setShowWireframeInterior(boolean show);

    void setShowWireframeExterior(boolean show);

    boolean isShowWireframeInterior();

    boolean isShowWireframeExterior();

    boolean isShowTessellationBoundingVolumes();

    void setShowTessellationBoundingVolumes(boolean showTileBoundingVolumes);
}
