/*
Copyright (C) 2001, 2006 United States Government
as represented by the Administrator of the
National Aeronautics and Space Administration.
All Rights Reserved.
*/
package gov.nasa.worldwind;

import gov.nasa.worldwind.geom.*;

import java.util.*;
import java.awt.event.*;

/**
 * @author tag
 * @version $Id: PositionEvent.java 1764 2007-05-07 20:01:57Z tgaskins $
 */
public class PositionEvent extends EventObject
{
    private final MouseEvent mouseEvent;
    private final Position position;
    private final Position previousPosition;

    public PositionEvent(Object source, MouseEvent mouseEvent, Position previousPosition, Position position)
    {
        super(source);
        this.mouseEvent = mouseEvent;
        this.position = position;
        this.previousPosition = previousPosition;
    }

    public Position getPosition()
    {
        return position;
    }

    public Position getPreviousPosition()
    {
        return previousPosition;
    }

    public MouseEvent getMouseEvent()
    {
        return mouseEvent;
    }

    @Override
    public String toString()
    {
        return this.getClass().getName() + " "
            + (this.previousPosition != null ? this.previousPosition : "null")
            + " --> "
            + (this.position != null ? this.position : "null");
    }
}
