/*
Copyright (C) 2001, 2006 United States Government
as represented by the Administrator of the
National Aeronautics and Space Administration.
All Rights Reserved.
*/
package gov.nasa.worldwind;

/**
 * @author Tom Gaskins
 * @version $Id: RetrievalService.java 693 2007-01-31 19:11:01Z tgaskins $
 */
public interface RetrievalService extends WWObject
{
    RetrievalFuture runRetriever(Retriever retriever);

    RetrievalFuture runRetriever(Retriever retriever, double priority);

    void setRetrieverPoolSize(int poolSize);

    int getRetrieverPoolSize();

    boolean hasActiveTasks();

    boolean isFull();

    boolean contains(gov.nasa.worldwind.Retriever retriever);

    int getNumRetrieversPending();
}
