/*
Copyright (C) 2001, 2006 United States Government
as represented by the Administrator of the
National Aeronautics and Space Administration.
All Rights Reserved.
*/
package gov.nasa.worldwind;

import gov.nasa.worldwind.geom.*;

/**
 * @author Tom Gaskins
 * @version $Id: SectorGeometry.java 1754 2007-05-06 23:19:22Z tgaskins $
 */
public interface SectorGeometry extends Renderable, Pickable, Cacheable
{
    public Extent getExtent();

    public Sector getSector();

    public Point getSurfacePoint(Angle latitude, Angle longitude, double metersOffset);

    public void pick(DrawContext dc, java.awt.Point pickPoint);

    void renderMultiTexture(DrawContext dc, int numTextureUnits);

    public void renderWireframe(DrawContext dc, boolean interior, boolean exterior);

    void renderBoundingVolume(DrawContext dc);
}
