/*
Copyright (C) 2001, 2006 United States Government
as represented by the Administrator of the
National Aeronautics and Space Administration.
All Rights Reserved.
*/
package gov.nasa.worldwind;

import java.util.*;

/**
 * @author tag
 * @version $Id$
 */
public class TrackPointIteratorImpl implements TrackPointIterator
{
    private java.util.List<Track> tracksList;
    private java.util.Iterator<Track> tracks;
    private java.util.Iterator<TrackSegment> segments;
    private java.util.Iterator<TrackPoint> positions;

    public TrackPointIteratorImpl(java.util.List<Track> tracksList)
    {
        this.tracksList = tracksList;
        this.reset();
    }

    public TrackPointIteratorImpl reset()
    {
        if (this.tracksList == null)
        {
            String msg = WorldWind.retrieveErrMsg("nullValue.TracksIsNull");
            WorldWind.logger().log(java.util.logging.Level.FINE, msg);
            throw new IllegalArgumentException(msg);
        }

        this.tracks = this.tracksList.iterator();
        this.segments = null;
        this.positions = null;
        this.loadNextPositions();

        return this;
    }

    public boolean hasNext()
    {
        if (this.positions != null && this.positions.hasNext())
            return true;

        this.loadNextPositions();

        return (this.positions != null && this.positions.hasNext());
    }

    private void loadNextPositions()
    {
        if (this.segments != null && this.segments.hasNext())
        {
            TrackSegment segment = this.segments.next();
            this.positions = segment.getPoints().iterator();
            return;
        }

        if (this.tracks.hasNext())
        {
            Track track = this.tracks.next();
            this.segments = track.getSegments().iterator();
            this.loadNextPositions();
        }
    }

    public TrackPoint next()
    {
        if (!this.hasNext())
        {
            String msg = WorldWind.retrieveErrMsg("iterator.NoMoreTrackPoints");
            WorldWind.logger().log(java.util.logging.Level.FINE, msg);
            throw new NoSuchElementException(msg);
        }

        return this.positions.next();
    }

    public void remove()
    {
        String msg = WorldWind.retrieveErrMsg("iterator.RemoveNotSupported");
        WorldWind.logger().log(java.util.logging.Level.FINE, msg);
        throw new UnsupportedOperationException(msg);
    }

    public int getNumPoints()
    {
        int numPoints;
        for (numPoints = 0; this.hasNext(); this.next())
            ++numPoints;

        return numPoints;
    }
}
