/*
Copyright (C) 2001, 2006 United States Government
as represented by the Administrator of the
National Aeronautics and Space Administration.
All Rights Reserved.
*/
package gov.nasa.worldwind;

/**
 * The top-level interface common to all toolkit-specific World Wind windows.
 *
 * @author Tom Gaskins
 * @version $Id: WorldWindow.java 1765 2007-05-07 20:51:41Z tgaskins $
 */
public interface WorldWindow
{
    /**
     * Sets the model to display in this window. If <code>null</code> is specified for the model, the current model, if
     * any, is disassociated with the window.
     *
     * @param model the model to display. May be <code>null</code>.
     */
    void setModel(Model model);

    /**
     * Returns the window's current model.
     *
     * @return the window's current model
     */
    Model getModel();

    /**
     * Sets the view to use when displaying this window's model. If <code>null</code> is specified for the view, the
     * current view, if any, is disassociated with the window.
     *
     * @param view the view to use to display this window's model. May be null.
     */
    void setView(View view);

    /**
     * Returns this window's current view.
     *
     * @return the window's current view
     */
    View getView();

    /**
     * Sets the model to display in this window and the view used to display it. If <code>null</code> is specified for
     * the model, the current model, if any, is disassociated with the window. If <code>null</code> is specified for the
     * view, the current view, if any, is disassociated with the window.
     *
     * @param model the model to display. May be<code>null</code>.
     * @param view  the view to use to display this window's model. May be<code>null</code>.
     */
    void setModelAndView(Model model, View view);

    /**
     * Returns the scene controller assocciated with this instance.
     *
     * @return The scene controller associated with the instance, or null if no scene controller is associated.
     */
    SceneController getSceneController();

    PickedObjectList pick(java.awt.Point pickPoint);

    InputHandler getInputHandler();

    void setInputHandler(InputHandler eventSource);

    void addRenderingListener(RenderingListener listener);

    void removeRenderingListener(RenderingListener listener);

    void addSelectListener(SelectListener listener);

    void removeSelectListener(SelectListener listener);

    void addPositionListener(PositionListener listener);

    void removePositionListener(PositionListener listener);
}
