/*
Copyright (C) 2001, 2006 United States Government
as represented by the Administrator of the
National Aeronautics and Space Administration.
All Rights Reserved.
*/
package gov.nasa.worldwind;

/**
 * An implementation class for the {@link WorldWindow} interface. Classes implementing <code>WorldWindow</code> can
 * subclass or aggreate this object to provide default <code>WorldWindow</code> functionality.
 *
 * @author Tom Gaskins
 * @version $Id: WorldWindowImpl.java 1764 2007-05-07 20:01:57Z tgaskins $
 */
public class WorldWindowImpl extends WWObjectImpl
{
    SceneController sceneController;

    public WorldWindowImpl()
    {
        // TODO: Determine this setup layout from configuration information

        this.sceneController = (SceneController) WorldWind.createConfigurationComponent(
            AVKey.SCENE_CONTROLLER_CLASS_NAME);
    }

    public void setModel(Model model)
    {
        // model can be null, that's ok - it indicates no model.
        if (this.sceneController != null)
            this.sceneController.setModel(model);
    }

    public gov.nasa.worldwind.Model getModel()
    {
        return this.sceneController != null ? this.sceneController.getModel() : null;
    }

    public void setView(gov.nasa.worldwind.View view)
    {
        // view can be null, that's ok - it indicates no view.
        if (this.sceneController != null)
            this.sceneController.setView(view);
    }

    public View getView()
    {
        return this.sceneController != null ? this.sceneController.getView() : null;
    }

    public void setModelAndView(Model model, View view)
    {
        this.setModel(model);
        this.setView(view);
    }

    public SceneController getSceneController()
    {
        return this.sceneController;
    }
}
