package gov.nasa.worldwind.formats.nitfs;

import gov.nasa.worldwind.*;
/*
Copyright (C) 2001, 2007 United States Government
as represented by the Administrator of the
National Aeronautics and Space Administration.
All Rights Reserved.
*/

/**
 * @author Lado Garakanidze
 * @version $Id: NitfsRuntimeException Mar 31, 2007 7:41:31 AM
 */
public final class NitfsRuntimeException extends java.lang.RuntimeException
{
    public NitfsRuntimeException()
    {
    }

    public NitfsRuntimeException(String messageID)
    {
        super(WorldWind.retrieveErrMsg(messageID));
        log(this.getMessage());
    }

    public NitfsRuntimeException(String messageID, String params)
    {
        super(WorldWind.retrieveErrMsg(messageID) + params);
        log(this.getMessage());
    }
    public NitfsRuntimeException(Throwable throwable)
    {
        super(throwable);
        log(this.getMessage());
    }
    public NitfsRuntimeException(String messageID, Throwable throwable)
    {
        super(WorldWind.retrieveErrMsg(messageID), throwable);
        log(this.getMessage());
    }
    public NitfsRuntimeException(String messageID, String params, Throwable throwable)
    {
        super(WorldWind.retrieveErrMsg(messageID) + params, throwable);
        log(this.getMessage());
    }
    private void log(String s)
    {
        WorldWind.logger().log(java.util.logging.Level.FINE, s);        
    }
}