package gov.nasa.worldwind.formats.nitfs;

import gov.nasa.worldwind.formats.rpf.*;
import gov.nasa.worldwind.*;
/*
Copyright (C) 2001, 2007 United States Government
as represented by the Administrator of the
National Aeronautics and Space Administration.
All Rights Reserved.
*/

/**
 * @author Lado Garakanidze
 * @version $Id: NitfsUserDefinedHeaderSegment Apr 4, 2007 6:07:10 PM lado
 */
public abstract class NitfsUserDefinedHeaderSegment extends NitfsSegment
{
    protected  int overflow;
    protected  String dataTag;

    public NitfsUserDefinedHeaderSegment(java.nio.ByteBuffer buffer)
    {
        super(NitfsSegmentType.UserDefinedHeaderSegment, buffer, 0, 0, 0, 0);

        this.headerLength = Integer.parseInt(NitfsUtil.getString(buffer, 5));
        this.overflow = Integer.parseInt(NitfsUtil.getString(buffer, 3));
        this.dataTag = NitfsUtil.getString(buffer, 6);
        this.dataLength = Integer.parseInt(NitfsUtil.getString(buffer, 5));
    }
}
