package gov.nasa.worldwind.formats.rpf;

import gov.nasa.worldwind.formats.nitfs.*;

import java.io.*;
/*
Copyright (C) 2001, 2007 United States Government
as represented by the Administrator of the
National Aeronautics and Space Administration.
All Rights Reserved.
*/

/**
 * @author lado
 * @version $Id: RpfFile Apr 8, 2007 8:53:48 AM
 */
public class RpfFile  
{
    private     NitfsMessage        nitfsMsg;
    private     java.io.File        rpfFile;

    public File getFile()
    {
        return this.rpfFile;
    }

    public NitfsFileHeader getNitfsFileHeader()
    {
        return (null != nitfsMsg) ? nitfsMsg.getNitfsFileHeader() : null;
    }

    public NitfsSegment getNitfsSegment(NitfsSegmentType segmentType)
    {
        return (null != nitfsMsg) ? nitfsMsg.getSegment(segmentType) : null;
    }

    protected RpfFile(java.io.File rpfFile) throws IOException
    {
        this.rpfFile = rpfFile;
        this.nitfsMsg = NitfsMessage.load(rpfFile);
    }
}
