package gov.nasa.worldwind.formats.rpf;
/*
Copyright (C) 2001, 2007 United States Government
as represented by the Administrator of the
National Aeronautics and Space Administration.
All Rights Reserved.
*/

/**
 * @author Lado Garakanidze
 * @version $Id: RpfFileComponents Apr 4, 2007 5:53:04 PM lado
 */
public class RpfFileComponents
{
    private java.nio.ByteBuffer  buffer;

    private RpfHeaderSection     headerSection;
    private RpfLocationSection   locationSection;

    public RpfFileComponents(java.nio.ByteBuffer buffer)
    {
        this.buffer = buffer;
        this.headerSection = new RpfHeaderSection(buffer);

        buffer.position(this.headerSection.locationSectionLocation);
        this.locationSection = new RpfLocationSection(buffer);
        
    }

    public RpfHeaderSection getRpfHeaderSection()
    {
        return this.headerSection;
    }

    public RpfFrameFileIndexSection getRpfFrameFileIndexSection()
    {
        if( 0 < locationSection.getFrameFileIndexSectionSubheaderLength())
        {
            this.buffer.position(locationSection.getFrameFileIndexSectionSubheaderLocation());
            return new RpfFrameFileIndexSection(buffer);
        }
        return null;
    }
}
