/*
Copyright (C) 2001, 2006 United States Government as represented by
the Administrator of the National Aeronautics and Space Administration.
All Rights Reserved.
*/
package gov.nasa.worldwind.formats.rpf;

/**
 * @author dcollins
 * @version $Id: RpfFrameProperties.java 1762 2007-05-07 19:43:55Z dcollins $
 */
public class RpfFrameProperties
{
    public final RpfZone zone;
    public final int frameNumber;
    public final RpfDataSeries dataSeries;
    public final RpfProducer producer;
    public final int version;
//    private final int hashCode;

    public RpfFrameProperties(RpfZone zone, int frameNumber, RpfDataSeries dataSeries, RpfProducer producer,
        int version)
    {
        this.zone = zone;
        this.frameNumber = frameNumber;
        this.dataSeries = dataSeries;
        this.producer = producer;
        this.version = version;
//        this.hashCode = this.computeHash();
    }

    private int computeHash()
    {
        int hash = 0;
        if (this.zone != null)
            hash = 29 * hash + this.zone.hashCode();
        if (this.dataSeries != null)
            hash = 29 * hash + this.dataSeries.hashCode();
        if (this.producer != null)
            hash = 29 * hash + producer.hashCode();
        hash = 29 * hash + version;
        hash = 29 * hash + frameNumber;
        return hash;
    }

    public boolean equals(Object o)
    {
        if (this == o)
            return true;
        if (o == null || o.getClass() != this.getClass())
            return false;
        final RpfFrameProperties that = (RpfFrameProperties) o;
        if (this.zone != that.zone)
            return false;
        if (this.frameNumber != that.frameNumber)
            return false;
        if (this.dataSeries != that.dataSeries)
            return false;
        if (this.producer != that.producer)
            return false;
        if (this.version != that.version)
            return false;
        return true;
    }

    public int hashCode()
    {
//        return this.hashCode;
        return this.computeHash();
    }

    public String toString()
    {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append('[');
        sb.append("zone=").append(this.zone);
        sb.append(", frameNumber=").append(this.frameNumber);
        sb.append(", dataSeries=").append(this.dataSeries);
        sb.append(", producer=").append(this.producer);
        sb.append(", version=").append(this.version);
        sb.append(']');
        return sb.toString();
    }
}
