/*
Copyright (C) 2001, 2006 United States Government as represented by
the Administrator of the National Aeronautics and Space Administration.
All Rights Reserved.
*/
package gov.nasa.worldwind.formats.rpf;

/**
 * @author dcollins
 * @version $Id: RpfFramePropertyType.java 1762 2007-05-07 19:43:55Z dcollins $
 */
public enum RpfFramePropertyType
{
    DataSeries(RpfDataSeries.class)
        {
            public Object getInstance(RpfFrameProperties frameProperties)
            {
                if (frameProperties == null)
                    return null;
                return frameProperties.dataSeries;
            }
        },
    FrameNumber(Integer.class)
        {
            public Object getInstance(RpfFrameProperties frameProperties)
            {
                if (frameProperties == null)
                    return null;
                return frameProperties.frameNumber;
            }
        },
    Producer(RpfProducer.class)
        {
            public Object getInstance(RpfFrameProperties frameProperties)
            {
                if (frameProperties == null)
                    return null;
                return frameProperties.producer;
            }
        },
    Version(Integer.class)
        {
            public Object getInstance(RpfFrameProperties frameProperties)
            {
                if (frameProperties == null)
                    return null;
                return frameProperties.version;
            }
        },
    Zone(RpfZone.class)
        {
            public Object getInstance(RpfFrameProperties frameProperties)
            {
                if (frameProperties == null)
                    return null;
                return frameProperties.zone;
            }
        };

    public final Class classType;

    private RpfFramePropertyType(Class classType)
    {
        this.classType = classType;
    }

    public abstract Object getInstance(RpfFrameProperties frameProperties);
}
