package gov.nasa.worldwind.formats.rpf;

import gov.nasa.worldwind.formats.nitfs.*;
/*
Copyright (C) 2001, 2007 United States Government
as represented by the Administrator of the
National Aeronautics and Space Administration.
All Rights Reserved.
*/

/**
 * @author Lado Garakanidze
 * @version $Id: RpfHeaderSection Apr 4, 2007 4:37:01 PM lado
 */
class RpfHeaderSection
{
    public static final String DATA_TAG = "RPFHDR";

    public boolean  endianIndicator;
    public short    headerLength;
    public String   filename;
    public short    updateIndicator; // new | replacement | update
    public String   govSpecNumber;
    public String   govSpecDate;
    public String   securityClass;
    public String   securityCountryCode;
    public String   securityReleaseMark;
    public int      locationSectionLocation;

    public RpfHeaderSection(java.nio.ByteBuffer buffer)
    {
        this.endianIndicator = ((byte) 0 != buffer.get());         // reads 1 byte, 0 for big endian
        this.headerLength = buffer.getShort();                     // reads 2 bytes
        this.filename = NitfsUtil.getString(buffer, 12);
        this.updateIndicator = NitfsUtil.getByteAsShort(buffer);       // reads 1 byte (short)
        this.govSpecNumber = NitfsUtil.getString(buffer, 15);
        this.govSpecDate = NitfsUtil.getString(buffer, 8);
        this.securityClass = NitfsUtil.getString(buffer, 1);
        this.securityCountryCode = NitfsUtil.getString(buffer, 2);
        this.securityReleaseMark = NitfsUtil.getString(buffer, 2);
        this.locationSectionLocation = buffer.getInt();            // read 4 bytes (int)
    }
}
