package gov.nasa.worldwind.formats.rpf;

import gov.nasa.worldwind.*;
import gov.nasa.worldwind.formats.nitfs.*;

import java.io.*;
import java.text.*;
/*
Copyright (C) 2001, 2007 United States Government
as represented by the Administrator of the
National Aeronautics and Space Administration.
All Rights Reserved.
*/

/**
 * @author Lado Garakanidze
 * @version $Id: RpfTocFile Apr 4, 2007 2:24:00 PM lado
 */
public class RpfTocFile extends RpfFile
{
    private RpfFileComponents rpfFileComponents;

    public RpfHeaderSection getHeaderSection()
    {
        return (null != this.rpfFileComponents) ? this.rpfFileComponents.getRpfHeaderSection() : null;
    }

    public RpfFrameFileIndexSection getFrameFileIndexSection()
    {
        return (null != this.rpfFileComponents) ? this.rpfFileComponents.getRpfFrameFileIndexSection() : null;
    }

    public RpfFileComponents getRpfFileComponents()
    {
        return this.rpfFileComponents;
    }

    protected RpfTocFile(java.io.File rpfFile) throws IOException, NitfsRuntimeException
    {
        super(rpfFile);

        RpfUserDefinedHeaderSegment segment =
            (RpfUserDefinedHeaderSegment)this.getNitfsSegment( NitfsSegmentType.UserDefinedHeaderSegment );

        if(null ==  segment)
            throw new NitfsRuntimeException("NitfsReader.UserDefinedHeaderSegmentWasNotFound");

        this.rpfFileComponents = segment.getRpfFileComponents();
        if(null == this.rpfFileComponents)
            throw new NitfsRuntimeException("NitfsReader.RpfFileComponents.Were.Not.Found.In.UserDefinedHeaderSegment");
    }

    public static RpfTocFile load(java.io.File tocFile) throws java.io.IOException
    {
        return new RpfTocFile(tocFile);
    }

    public static void main(String args[])
    {
        String testTocFilename = (Configuration.isWindowsOS()) ?  "C:\\RPF\\A.TOC" : "/depot/WorldWindJ/utils/rpf/A.TOC";
        try
        {
            long startTime = System.currentTimeMillis();

            RpfTocFile toc = RpfTocFile.load(new File(testTocFilename));

            System.out.println(MessageFormat.format("TOC file loaded in {0} mSec", (System.currentTimeMillis() - startTime)));
        }
        catch (Exception e)
        {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }
}
