package gov.nasa.worldwind.formats.rpf;

import gov.nasa.worldwind.formats.nitfs.*;
import gov.nasa.worldwind.*;
/*
Copyright (C) 2001, 2007 United States Government
as represented by the Administrator of the
National Aeronautics and Space Administration.
All Rights Reserved.
*/

/**
 * @author Lado Garakanidze
 * @version $Id: RpfUserDefinedHeaderSegment Apr 17, 2007 6:55:38 PM lado
 */
public class RpfUserDefinedHeaderSegment extends NitfsUserDefinedHeaderSegment
{
    private RpfFileComponents   components;

    public RpfUserDefinedHeaderSegment(java.nio.ByteBuffer buffer)
    {
        super(buffer);

        if(StringUtil.Equals(RpfHeaderSection.DATA_TAG, this.dataTag))
        {
            this.components = new RpfFileComponents(buffer);
        }
        else
            throw new NitfsRuntimeException("NitfsReader.RpfHeaderNotFoundInUserDefinedSegment", this.dataTag);
        this.restoreBufferPosition();
    }

    public RpfFileComponents getRpfFileComponents()
    {
        return this.components;
    }
}
