/*
Copyright (C) 2001, 2006 United States Government
as represented by the Administrator of the
National Aeronautics and Space Administration.
All Rights Reserved.
*/
package gov.nasa.worldwind.geom;

import gov.nasa.worldwind.*;

/**
 * @author tag
 * @version $Id: Position.java 1755 2007-05-06 23:38:05Z tgaskins $
 */
public class Position
{
    private final Angle latitude;
    private final Angle longitude;
    private final double elevation;

    public static final Position ZERO = new Position(Angle.ZERO, Angle.ZERO, 0d);

    public static Position fromRadians(double latitude, double longitude, double elevation)
    {
        return new Position(Angle.fromRadians(latitude), Angle.fromRadians(longitude), elevation);
    }

    public static Position fromDegrees(double latitude, double longitude, double elevation)
    {
        return new Position(Angle.fromDegrees(latitude), Angle.fromDegrees(longitude), elevation);
    }

    public Position(Angle latitude, Angle longitude, double elevation)
    {
        if (latitude == null || longitude == null)
        {
            String message = WorldWind.retrieveErrMsg("nullValue.LatitudeOrLongitudeIsNull");
            WorldWind.logger().log(java.util.logging.Level.FINE, message);
            throw new IllegalArgumentException(message);
        }

        this.latitude = latitude;
        this.longitude = longitude;
        this.elevation = elevation;
    }

    /**
     * Obtains the latitude of this position
     *
     * @return this position's latitude
     */
    public final Angle getLatitude()
    {
        return this.latitude;
    }

    /**
     * Obtains the longitude of this position
     *
     * @return this position's longitude
     */
    public final Angle getLongitude()
    {
        return this.longitude;
    }

    /**
     * Obtains the elevation of this position
     *
     * @return this position's elevation
     */
    public final double getElevation()
    {
        return this.elevation;
    }
}
