/*
Copyright (C) 2001, 2006 United States Government
as represented by the Administrator of the
National Aeronautics and Space Administration.
All Rights Reserved.
*/
package gov.nasa.worldwind.globes;

import gov.nasa.worldwind.geom.*;
import gov.nasa.worldwind.*;

/**
 * @author Tom Gaskins
 * @version $Id: EarthElevationModel.java 1731 2007-05-05 05:57:22Z tgaskins $
 */
public class EarthElevationModel extends BasicElevationModel
{
    private static double HEIGHT_OF_MT_EVEREST = 8850d; // meters
    private static double DEPTH_OF_MARIANAS_TRENCH = -11000d; // meters

    public EarthElevationModel()
    {
        super(makeLevels(), DEPTH_OF_MARIANAS_TRENCH, HEIGHT_OF_MT_EVEREST);
        this.setNumExpectedValuesPerTile(22500);
    }

    private static LevelSet makeLevels()
    {
        AVList params = new AVListImpl();

        params.setValue(Level.TILE_WIDTH, 150);
        params.setValue(Level.TILE_HEIGHT, 150);
        params.setValue(Level.CACHE_NAME, "Earth/srtm30pluszip");
        params.setValue(Level.SERVICE, "http://worldwind25.arc.nasa.gov/wwelevation/wwelevation.aspx");
        params.setValue(Level.DATASET_NAME, "srtm30pluszip");
        params.setValue(Level.FORMAT_SUFFIX, ".bil");
        params.setValue(Level.NUM_LEVELS, 12);
        params.setValue(Level.NUM_EMPTY_LEVELS, 0);
        params.setValue(Level.LEVEL_ZERO_TILE_DELTA, new LatLon(Angle.fromDegrees(20d), Angle.fromDegrees(20d)));
        params.setValue(AVKey.SECTOR, Sector.FULL_SPHERE);

        return new LevelSet(params);
    }
}
